/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.Collections;
import java.util.LinkedList;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeKeyResolver;
import org.apache.commons.configuration2.tree.NodeSelector;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.QueryResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestNodeSelector {
    private static final String KEY = "tables.testKey";
    private static ImmutableNode root;
    private static NodeKeyResolver<ImmutableNode> resolver;
    private static NodeHandler<ImmutableNode> handler;

    private static NodeKeyResolver<ImmutableNode> createResolver() {
        NodeKeyResolver<ImmutableNode> resolver = NodeStructureHelper.createResolverMock();
        NodeStructureHelper.prepareResolveKeyForQueries(resolver);
        return resolver;
    }

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        resolver = TestNodeSelector.createResolver();
        handler = new InMemoryNodeModel().getNodeHandler();
        root = new ImmutableNode.Builder(1).addChild(NodeStructureHelper.ROOT_TABLES_TREE).create();
    }

    @Test
    public void testEqualsFalse() {
        NodeSelector selector = new NodeSelector(KEY);
        NodeSelector sel2 = new NodeSelector("othertables.testKey");
        ConfigurationAssert.checkEquals(selector, sel2, false);
        sel2 = new NodeSelector(KEY).subSelector(KEY);
        ConfigurationAssert.checkEquals(selector, sel2, false);
    }

    @Test
    public void testEqualsOtherObjects() {
        NodeSelector selector = new NodeSelector(KEY);
        ConfigurationAssert.checkEquals(selector, null, false);
        ConfigurationAssert.checkEquals(selector, this, false);
    }

    @Test
    public void testEqualsTrue() {
        NodeSelector selector = new NodeSelector(KEY);
        ConfigurationAssert.checkEquals(selector, selector, true);
        NodeSelector sel2 = new NodeSelector(KEY);
        ConfigurationAssert.checkEquals(selector, sel2, true);
        NodeSelector sub1 = selector.subSelector("k2");
        NodeSelector sub2 = sel2.subSelector("k2");
        ConfigurationAssert.checkEquals(sub1, sub2, true);
    }

    @Test
    public void testSelectIgnoreAttributeResults() {
        NodeKeyResolver<ImmutableNode> resolverMock = NodeStructureHelper.createResolverMock();
        LinkedList<QueryResult> results = new LinkedList<QueryResult>();
        results.add(QueryResult.createAttributeResult((Object)NodeStructureHelper.nodeForKey(root, "tables/table(0)"), (String)"type"));
        ImmutableNode target = NodeStructureHelper.nodeForKey(root, "tables/table(1)");
        results.add(QueryResult.createNodeResult((Object)target));
        results.add(QueryResult.createAttributeResult((Object)NodeStructureHelper.nodeForKey(root, "tables/table(0)/fields/field(1)"), (String)"type"));
        Mockito.when((Object)resolverMock.resolveKey((Object)root, KEY, handler)).thenReturn(results);
        NodeSelector selector = new NodeSelector(KEY);
        Assertions.assertSame((Object)target, (Object)selector.select(root, resolverMock, handler));
    }

    @Test
    public void testSelectMultipleTargets() {
        NodeSelector selector = new NodeSelector("tables.table.name");
        Assertions.assertNull((Object)selector.select(root, resolver, handler));
    }

    @Test
    public void testSelectSingleAttributeKey() {
        NodeKeyResolver<ImmutableNode> resolverMock = NodeStructureHelper.createResolverMock();
        Mockito.when((Object)resolverMock.resolveKey((Object)root, KEY, handler)).thenReturn(Collections.singletonList(QueryResult.createAttributeResult((Object)root, (String)KEY)));
        NodeSelector selector = new NodeSelector(KEY);
        Assertions.assertNull((Object)selector.select(root, resolverMock, handler));
    }

    @Test
    public void testSelectSingleKeySuccess() {
        NodeSelector selector = new NodeSelector("tables.table(0).name");
        ImmutableNode target = selector.select(root, resolver, handler);
        Assertions.assertEquals((Object)"name", (Object)target.getNodeName());
        Assertions.assertEquals((Object)NodeStructureHelper.table(0), (Object)target.getValue());
    }

    @Test
    public void testSelectSubKey() {
        NodeSelector selectorParent = new NodeSelector("tables.table(0)");
        NodeSelector selector = selectorParent.subSelector("fields.field(1).name");
        ImmutableNode target = selector.select(root, resolver, handler);
        Assertions.assertEquals((Object)NodeStructureHelper.field(0, 1), (Object)target.getValue());
    }

    @Test
    public void testSelectSubKeyComplexEvaluation() {
        NodeSelector first = new NodeSelector("tables.table");
        NodeSelector second = first.subSelector("fields");
        int fldIdx = NodeStructureHelper.fieldsLength(1) - 1;
        NodeSelector selector = second.subSelector("field(" + fldIdx + ").name");
        ImmutableNode target = selector.select(root, resolver, handler);
        Assertions.assertEquals((Object)NodeStructureHelper.field(1, fldIdx), (Object)target.getValue());
    }

    @Test
    public void testSelectSubKeyMultipleResults() {
        NodeSelector selectorParent = new NodeSelector("tables.table");
        NodeSelector selector = selectorParent.subSelector("fields.field(1).name");
        Assertions.assertNull((Object)selector.select(root, resolver, handler));
    }

    @Test
    public void testSelectSubKeyUnknown() {
        NodeSelector selectorParent = new NodeSelector("tables.unknown");
        NodeSelector selector = selectorParent.subSelector("fields.field(1).name");
        Assertions.assertNull((Object)selector.select(root, resolver, handler));
    }

    @Test
    public void testToString() {
        String key2 = "anotherSelectionKey";
        NodeSelector selector = new NodeSelector(KEY).subSelector("anotherSelectionKey");
        String s = selector.toString();
        Assertions.assertTrue((boolean)s.contains(KEY));
        Assertions.assertTrue((boolean)s.contains("anotherSelectionKey"));
    }
}

