/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.io.File;
import java.util.Collection;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.CombinedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.ReloadingCombinedConfigurationBuilder;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.reloading.CombinedReloadingController;
import org.apache.commons.configuration2.reloading.ReloadingController;
import org.apache.commons.configuration2.reloading.ReloadingControllerSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestReloadingCombinedConfigurationBuilder {
    private ReloadingCombinedConfigurationBuilder builder;

    @BeforeEach
    public void setUp() throws Exception {
        this.builder = new ReloadingCombinedConfigurationBuilder();
    }

    @Test
    public void testInitWithFailOnInitFlag() {
        this.builder = new ReloadingCombinedConfigurationBuilder(null, true);
        Assertions.assertTrue((boolean)this.builder.isAllowFailOnInit());
    }

    @Test
    public void testInitWithParameters() throws ConfigurationException {
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        params.setFile(ConfigurationAssert.getTestFile("testDigesterConfiguration.xml"));
        this.builder = new ReloadingCombinedConfigurationBuilder(params.getParameters());
        CombinedConfiguration cc = this.builder.getConfiguration();
        Assertions.assertTrue((boolean)cc.getBoolean("test.boolean"));
    }

    @Test
    public void testNestedReloadableSources() throws ConfigurationException {
        File testFile = ConfigurationAssert.getTestFile("testCCReloadingNested.xml");
        this.builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(testFile)});
        this.builder.getConfiguration();
        CombinedReloadingController rc = (CombinedReloadingController)this.builder.getReloadingController();
        Collection subControllers = rc.getSubControllers();
        Assertions.assertEquals((int)2, (int)subControllers.size());
        ReloadingControllerSupport ccBuilder = (ReloadingControllerSupport)this.builder.getNamedBuilder("cc");
        Assertions.assertTrue((boolean)subControllers.contains(ccBuilder.getReloadingController()));
        CombinedReloadingController rc2 = (CombinedReloadingController)ccBuilder.getReloadingController();
        Assertions.assertEquals((int)3, (int)rc2.getSubControllers().size());
    }

    @Test
    public void testNoReloadableSources() throws ConfigurationException {
        File testFile = ConfigurationAssert.getTestFile("testDigesterConfiguration.xml");
        this.builder.configure(new BuilderParameters[]{new CombinedBuilderParametersImpl().setDefinitionBuilder((ConfigurationBuilder)new FileBasedConfigurationBuilder(XMLConfiguration.class)).setDefinitionBuilderParameters((BuilderParameters)new FileBasedBuilderParametersImpl().setFile(testFile))});
        this.builder.getConfiguration();
        CombinedReloadingController rc = (CombinedReloadingController)this.builder.getReloadingController();
        Assertions.assertTrue((boolean)rc.getSubControllers().isEmpty());
    }

    @Test
    public void testReloadableDefinitionBuilder() throws ConfigurationException {
        File testFile = ConfigurationAssert.getTestFile("testDigesterConfiguration.xml");
        ReloadingCombinedConfigurationBuilder confBuilder = this.builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(testFile)});
        Assertions.assertSame((Object)this.builder, (Object)confBuilder);
        this.builder.getConfiguration();
        CombinedReloadingController rc = (CombinedReloadingController)this.builder.getReloadingController();
        Collection subControllers = rc.getSubControllers();
        Assertions.assertEquals((int)1, (int)subControllers.size());
        ReloadingController subctrl = ((ReloadingControllerSupport)this.builder.getDefinitionBuilder()).getReloadingController();
        Assertions.assertSame((Object)subctrl, subControllers.iterator().next());
    }
}

