/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.io.File;
import java.util.HashMap;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.combined.CombinedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.TestCombinedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.io.VFSFileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCombinedConfigurationBuilderVFS
extends TestCombinedConfigurationBuilder {
    @Override
    protected FileBasedBuilderParameters createParameters() {
        FileBasedBuilderParameters params = super.createParameters();
        return (FileBasedBuilderParameters)params.setFileSystem((FileSystem)new VFSFileSystem());
    }

    @Test
    public void testSetConfigurationBasePath() throws ConfigurationException {
        File deepDir = new File(ConfigurationAssert.TEST_DIR, "config/deep");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fileName", "test.properties");
        BaseHierarchicalConfiguration defConfig = TestCombinedConfigurationBuilderVFS.createDefinitionConfig("properties", params);
        defConfig.addProperty("override.properties.fileSystem[@config-class]", (Object)VFSFileSystem.class.getName());
        BasicConfigurationBuilder<? extends BaseHierarchicalConfiguration> defBuilder = TestCombinedConfigurationBuilderVFS.createDefinitionBuilder(defConfig);
        this.builder.configure(new BuilderParameters[]{new CombinedBuilderParametersImpl().setDefinitionBuilder(defBuilder).setBasePath(deepDir.getAbsolutePath())});
        Configuration config = (Configuration)this.builder.getConfiguration();
        Assertions.assertEquals((Object)"somevalue", (Object)config.getString("somekey"));
    }
}

