/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jdbc.internal;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class Reflections {
    private Reflections() {
    }

    public static Object get(final Object instance, String field) {
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                final Field f = clazz.getDeclaredField(field);
                final boolean acc = f.isAccessible();
                return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        f.setAccessible(true);
                        try {
                            Object object = f.get(instance);
                            return object;
                        }
                        catch (IllegalAccessException ex) {
                            throw new IllegalArgumentException(ex);
                        }
                        finally {
                            f.setAccessible(acc);
                        }
                    }
                });
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new RuntimeException(new NoSuchFieldException(field));
    }
}

