/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: AccessorCache.java,v $
 * Version:       $Name:  $ $Revision: 1.3 $
 * Last Modified: $Date: 2004/06/21 11:48:01 $
 *****************************************************************************/
package org.ten60.netkernel.cache;

import com.ten60.netkernel.cache.ICachelet;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.util.SysLogger;
import org.ten60.netkernel.xml.util.XMLUtils;
import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.module.ModuleDefinition;

import java.util.*;

/**
 * Only caches accessors
 * @author  tab
 */
public final class AccessorCache implements ICachelet
{
	private Map mMap = new HashMap();
	/** Creates a new instance of NullCache */
	public AccessorCache()
	{
	}
	
public IURRepresentation get(URRequest aRequest)
	{	IURRepresentation result=null;
		Object key = getKeyFor(aRequest);
		if (key!=null)
		{	synchronized(mMap)
			{	result = (IURRepresentation)mMap.get(key);
				if (result!=null)
				{	if (hasExpired(result))
					{	mMap.remove(key);
						result=null;
					}
				}
			}
		}
				
		//if (result!=null) SysLogger.log1(SysLogger.INFO, this, Boolean.toString(result!=null)+" SimpleCache.get(%1)",aRequest.toString());
		return result;
	}
	
	public void init(Container aContainer, ModuleDefinition aModule)
	{
	}
	
	public void put(URResult aResult)
	{	boolean put=false;
		IURRepresentation resource = aResult.getResource();
		if (!hasExpired(resource))
		{	Object key = getKeyFor(aResult.getRequest());
			
			if (key!=null)
			{	synchronized(mMap)
				{	mMap.put(key,resource);
				}
				put=true;
			}
		}
		//if (put) SysLogger.log1(SysLogger.INFO, this, Boolean.toString(put)+" SimpleCache.put(%1)",aResult.getRequest().toString());
	}
	
	private CacheKey getKeyFor(URRequest aRequest)
	{	CacheKey result=null;
		if (aRequest.getType()==URRequest.RQT_SOURCE || aRequest.getType()==URRequest.RQT_TRANSREPRESENT)
		{	String scheme = aRequest.getURI().getScheme();
			if (scheme.equals("ura"))
			{	result = new CacheKey(aRequest,false);
			}
		}
		return result;
	}
	
	private boolean hasExpired(IURRepresentation aProxy)
	{	if (aProxy.getMeta()==null)
		{	System.out.println("null");
		}
		long expiryTime = aProxy.getMeta().getPessimisticExpiryTime();
		return (expiryTime<System.currentTimeMillis() && aProxy.getMeta().isExpired());
	}
	
	public void write(java.io.Writer aWriter) throws java.io.IOException
	{	synchronized(mMap)
		{	for (Iterator i = mMap.entrySet().iterator(); i.hasNext(); )
			{	Map.Entry entry = (Map.Entry)i.next();
				CacheKey key = (CacheKey)entry.getKey();
				aWriter.write("<key>");
				aWriter.write(XMLUtils.escape(key.getURI().toString()));
				aWriter.write("</key>");
			}
		}
	}
	
	public ICachelet getBackingCache()
	{	return null;
	}	
	
}
