/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsResponse;
import software.amazon.awssdk.services.ec2.model.IpamPool;

public class DescribeIpamPoolsIterable
implements SdkIterable<DescribeIpamPoolsResponse> {
    private final Ec2Client client;
    private final DescribeIpamPoolsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeIpamPoolsIterable(Ec2Client client, DescribeIpamPoolsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeIpamPoolsResponseFetcher();
    }

    public Iterator<DescribeIpamPoolsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IpamPool> ipamPools() {
        Function<DescribeIpamPoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamPools() != null) {
                return response.ipamPools().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeIpamPoolsResponseFetcher
    implements SyncPageFetcher<DescribeIpamPoolsResponse> {
        private DescribeIpamPoolsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIpamPoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeIpamPoolsResponse nextPage(DescribeIpamPoolsResponse previousPage) {
            if (previousPage == null) {
                return DescribeIpamPoolsIterable.this.client.describeIpamPools(DescribeIpamPoolsIterable.this.firstRequest);
            }
            return DescribeIpamPoolsIterable.this.client.describeIpamPools((DescribeIpamPoolsRequest)((Object)DescribeIpamPoolsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

