/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpAddressType;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdStringListRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstanceConnectEndpointRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyInstanceConnectEndpointRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyInstanceConnectEndpointRequest.getter(ModifyInstanceConnectEndpointRequest::dryRun)).setter(ModifyInstanceConnectEndpointRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> INSTANCE_CONNECT_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceConnectEndpointId").getter(ModifyInstanceConnectEndpointRequest.getter(ModifyInstanceConnectEndpointRequest::instanceConnectEndpointId)).setter(ModifyInstanceConnectEndpointRequest.setter(Builder::instanceConnectEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConnectEndpointId").unmarshallLocationName("InstanceConnectEndpointId").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressType").getter(ModifyInstanceConnectEndpointRequest.getter(ModifyInstanceConnectEndpointRequest::ipAddressTypeAsString)).setter(ModifyInstanceConnectEndpointRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").unmarshallLocationName("IpAddressType").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(ModifyInstanceConnectEndpointRequest.getter(ModifyInstanceConnectEndpointRequest::securityGroupIds)).setter(ModifyInstanceConnectEndpointRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PRESERVE_CLIENT_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PreserveClientIp").getter(ModifyInstanceConnectEndpointRequest.getter(ModifyInstanceConnectEndpointRequest::preserveClientIp)).setter(ModifyInstanceConnectEndpointRequest.setter(Builder::preserveClientIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreserveClientIp").unmarshallLocationName("PreserveClientIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, INSTANCE_CONNECT_ENDPOINT_ID_FIELD, IP_ADDRESS_TYPE_FIELD, SECURITY_GROUP_IDS_FIELD, PRESERVE_CLIENT_IP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyInstanceConnectEndpointRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String instanceConnectEndpointId;
    private final String ipAddressType;
    private final List<String> securityGroupIds;
    private final Boolean preserveClientIp;

    private ModifyInstanceConnectEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.instanceConnectEndpointId = builder.instanceConnectEndpointId;
        this.ipAddressType = builder.ipAddressType;
        this.securityGroupIds = builder.securityGroupIds;
        this.preserveClientIp = builder.preserveClientIp;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String instanceConnectEndpointId() {
        return this.instanceConnectEndpointId;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final Boolean preserveClientIp() {
        return this.preserveClientIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceConnectEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.preserveClientIp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceConnectEndpointRequest)) {
            return false;
        }
        ModifyInstanceConnectEndpointRequest other = (ModifyInstanceConnectEndpointRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.instanceConnectEndpointId(), other.instanceConnectEndpointId()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.preserveClientIp(), other.preserveClientIp());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyInstanceConnectEndpointRequest").add("DryRun", (Object)this.dryRun()).add("InstanceConnectEndpointId", (Object)this.instanceConnectEndpointId()).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("PreserveClientIp", (Object)this.preserveClientIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "InstanceConnectEndpointId": {
                return Optional.ofNullable(clazz.cast(this.instanceConnectEndpointId()));
            }
            case "IpAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "PreserveClientIp": {
                return Optional.ofNullable(clazz.cast(this.preserveClientIp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("InstanceConnectEndpointId", INSTANCE_CONNECT_ENDPOINT_ID_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("SecurityGroupId", SECURITY_GROUP_IDS_FIELD);
        map.put("PreserveClientIp", PRESERVE_CLIENT_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceConnectEndpointRequest, T> g) {
        return obj -> g.apply((ModifyInstanceConnectEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String instanceConnectEndpointId;
        private String ipAddressType;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean preserveClientIp;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceConnectEndpointRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.instanceConnectEndpointId(model.instanceConnectEndpointId);
            this.ipAddressType(model.ipAddressType);
            this.securityGroupIds(model.securityGroupIds);
            this.preserveClientIp(model.preserveClientIp);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getInstanceConnectEndpointId() {
            return this.instanceConnectEndpointId;
        }

        public final void setInstanceConnectEndpointId(String instanceConnectEndpointId) {
            this.instanceConnectEndpointId = instanceConnectEndpointId;
        }

        @Override
        public final Builder instanceConnectEndpointId(String instanceConnectEndpointId) {
            this.instanceConnectEndpointId = instanceConnectEndpointId;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListRequestCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListRequestCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Boolean getPreserveClientIp() {
            return this.preserveClientIp;
        }

        public final void setPreserveClientIp(Boolean preserveClientIp) {
            this.preserveClientIp = preserveClientIp;
        }

        @Override
        public final Builder preserveClientIp(Boolean preserveClientIp) {
            this.preserveClientIp = preserveClientIp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceConnectEndpointRequest build() {
            return new ModifyInstanceConnectEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyInstanceConnectEndpointRequest> {
        public Builder dryRun(Boolean var1);

        public Builder instanceConnectEndpointId(String var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder preserveClientIp(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

