/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.rules.patterns.StringMatcher;
import org.languagetool.rules.patterns.Substrings;

public class StringMatcherTest {
    @Test(expected=PatternSyntaxException.class)
    public void syntaxIsValidated() {
        StringMatcher.regexp((String)"t\u00fa|?");
    }

    @Test
    public void testGetPossibleValues() {
        StringMatcherTest.assertPossibleValues("x.*", new String[0]);
        StringMatcherTest.assertPossibleValues("x+", new String[0]);
        StringMatcherTest.assertPossibleValues("a.c", new String[0]);
        StringMatcherTest.assertPossibleValues("a{2}", new String[0]);
        StringMatcherTest.assertPossibleValues("[a-z]", new String[0]);
        StringMatcherTest.assertPossibleValues("[^a]", new String[0]);
        StringMatcherTest.assertPossibleValues("a[a-z]", new String[0]);
        StringMatcherTest.assertPossibleValues("(?=a)", new String[0]);
        StringMatcherTest.assertPossibleValues("", "");
        StringMatcherTest.assertPossibleValues("^x$", "x");
        StringMatcherTest.assertPossibleValues("aa|bb", "aa", "bb");
        StringMatcherTest.assertPossibleValues("aa", "aa");
        StringMatcherTest.assertPossibleValues("aa|", "aa", "");
        StringMatcherTest.assertPossibleValues("aa?", "aa", "a");
        StringMatcherTest.assertPossibleValues("[abc]", "a", "b", "c");
        StringMatcherTest.assertPossibleValues("[abc]", "a", "b", "c");
        StringMatcherTest.assertPossibleValues("a(bc)?", "a", "abc");
        StringMatcherTest.assertPossibleValues("a(b|c)", "ab", "ac");
        StringMatcherTest.assertPossibleValues("(a|b)(c|d)", "ac", "ad", "bc", "bd");
        StringMatcherTest.assertPossibleValues("\\.|\\-", ".", "-");
        StringMatcherTest.assertPossibleValues("[\\.\\-]", ".", "-");
        StringMatcherTest.assertPossibleValues("are|is|w(?:as|ere)", "are", "is", "was", "were");
        StringMatcherTest.assertPossibleValues("[,;:-]", ",", ";", ":", "-");
        StringMatcherTest.assertPossibleValues("(?:[-\u2011])", "-", "\u2011");
        StringMatcherTest.assertPossibleValues("[0-9]", (String[])IntStream.range(0, 10).mapToObj(String::valueOf).toArray(String[]::new));
        StringMatcherTest.assertPossibleValues("[0-9X]", (String[])Stream.concat(IntStream.range(0, 10).mapToObj(String::valueOf), Stream.of("X")).toArray(String[]::new));
        StringMatcherTest.assertPossibleValues("t\u00fa|\\?", "t\u00fa", "?");
        StringMatcherTest.assertPossibleValues("NN|PRP\\$", "NN", "PRP$");
        StringMatcherTest.assertPossibleValues("\\\\b", "\\b");
    }

    private static void assertPossibleValues(String regexp, String ... expected) {
        Assert.assertEquals((Object)(expected.length == 0 ? null : Sets.newHashSet((Object[])expected)), (Object)StringMatcher.getPossibleRegexpValues((String)regexp));
        for (String s : expected) {
            StringMatcherTest.trySomeMutations(regexp, s);
        }
        StringMatcherTest.trySomeMutations(regexp, regexp);
    }

    private static void trySomeMutations(String regexp, String s) {
        StringMatcherTest.assertStringMatcherConsistentWithPattern(regexp, s);
        for (int i = 0; i < s.length(); ++i) {
            StringMatcherTest.assertStringMatcherConsistentWithPattern(regexp, s.substring(0, i) + s.substring(i + 1));
            StringMatcherTest.assertStringMatcherConsistentWithPattern(regexp, s.substring(0, i) + "x" + s.substring(i + 1));
        }
        StringMatcherTest.assertStringMatcherConsistentWithPattern(regexp, "a" + s);
        StringMatcherTest.assertStringMatcherConsistentWithPattern(regexp, s + "a");
    }

    private static void assertStringMatcherConsistentWithPattern(String regexp, String s) {
        Assert.assertEquals((Object)StringMatcher.regexp((String)regexp).matches(s), (Object)s.matches(regexp));
        Assert.assertEquals((Object)StringMatcher.create((String)regexp, (boolean)true, (boolean)false).matches(s), (Object)Pattern.compile(regexp, 66).matcher(s).matches());
    }

    @Test
    public void requiredSubstrings() {
        StringMatcherTest.assertRequiredSubstrings("", "[]");
        StringMatcherTest.assertRequiredSubstrings("foo", "[foo]");
        StringMatcherTest.assertRequiredSubstrings("foo|bar", null);
        StringMatcherTest.assertRequiredSubstrings("\\w", null);
        StringMatcherTest.assertRequiredSubstrings("PRP.+", "[PRP)");
        StringMatcherTest.assertRequiredSubstrings(".*PRP.+", "(PRP)");
        StringMatcherTest.assertRequiredSubstrings(".*PRP", "(PRP]");
        StringMatcherTest.assertRequiredSubstrings(".+PRP", "(PRP]");
        StringMatcherTest.assertRequiredSubstrings("a.+b", "[a, b]");
        StringMatcherTest.assertRequiredSubstrings("a.*b", "[a, b]");
        StringMatcherTest.assertRequiredSubstrings("\\bZ\u00fcnglein an der (Wage)\\b", "[Z\u00fcnglein an der Wage]");
        StringMatcherTest.assertRequiredSubstrings("(\u00f6kumenische[rn]?) (.*Messen?)", "[\u00f6kumenische,  , Messe)");
        StringMatcherTest.assertRequiredSubstrings("(CO2|Kohlendioxid|Schadstoff)\\-?Emulsion(en)?", "(Emulsion)");
        StringMatcherTest.assertRequiredSubstrings("\\bder (\\w*(Verkehrs|Verbots|Namens|Hinweis|Warn)schild)", "[der , schild]");
        StringMatcherTest.assertRequiredSubstrings("\\bvon Seiten\\b", "[von Seiten]");
        StringMatcherTest.assertRequiredSubstrings("((\\-)?[0-9]+[0-9.,]{0,15})(?:[\\s\u00a0\u202f]+)(\u00b0[^CFK])", "(\u00b0)");
        StringMatcherTest.assertRequiredSubstrings("\\b(teils\\s[^,]+\\steils)\\b", "[teils, teils]");
        StringMatcherTest.assertRequiredSubstrings("\u00a7 ?(\\d+[a-z]?)", "[\u00a7)");
    }

    @Test
    public void noSOEOnLongDisjunction() {
        int count = 100000;
        String pattern = IntStream.range(0, count).mapToObj(i -> "a" + i).collect(Collectors.joining("|"));
        StringMatcher matcher = StringMatcher.create((String)pattern, (boolean)true, (boolean)true);
        for (int i2 = 0; i2 < count; ++i2) {
            Assert.assertTrue((boolean)matcher.matches("a" + i2));
            Assert.assertFalse((boolean)matcher.matches("b" + i2));
        }
    }

    private static void assertRequiredSubstrings(String regexp, @Nullable String expected) {
        Substrings actual = StringMatcher.getRequiredSubstrings((String)regexp);
        Assert.assertEquals((Object)expected, (Object)(actual == null ? null : actual.toString()));
        StringMatcherTest.trySomeMutations(regexp, regexp);
        if (expected != null) {
            StringMatcherTest.trySomeMutations(regexp, expected);
            StringMatcherTest.trySomeMutations(regexp, expected.substring(1, expected.length() - 1));
        }
        if (actual != null) {
            for (String separator : Arrays.asList("", "a", "0", " ")) {
                StringMatcherTest.trySomeMutations(regexp, String.join((CharSequence)separator, actual.substrings));
                StringMatcherTest.trySomeMutations(regexp, separator + String.join((CharSequence)separator, actual.substrings));
                StringMatcherTest.trySomeMutations(regexp, String.join((CharSequence)separator, actual.substrings) + separator);
            }
        }
    }
}

