/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.ivyservice.LenientConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.LocalDependencyFiles;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSetResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.VisitedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResults;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.VariantIdentifier;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.jspecify.annotations.Nullable;

public class DefaultLenientConfiguration
implements LenientConfigurationInternal {
    private final ResolutionHost resolutionHost;
    private final VisitedGraphResults graphResults;
    private final VisitedArtifactSet artifactResults;
    private final Function<SelectedArtifactResults, TransientConfigurationResults> legacyArtifactResultsLoader;
    private final ResolvedArtifactSetResolver artifactSetResolver;
    private final ArtifactSelectionSpec implicitSelectionSpec;
    private @Nullable SelectedArtifactResults artifactsForThisConfiguration;

    public DefaultLenientConfiguration(ResolutionHost resolutionHost, VisitedGraphResults graphResults, VisitedArtifactSet artifactResults, Function<SelectedArtifactResults, TransientConfigurationResults> legacyArtifactResultsLoader, ResolvedArtifactSetResolver artifactSetResolver, ArtifactSelectionSpec implicitSelectionSpec) {
        this.resolutionHost = resolutionHost;
        this.graphResults = graphResults;
        this.artifactResults = artifactResults;
        this.legacyArtifactResultsLoader = legacyArtifactResultsLoader;
        this.artifactSetResolver = artifactSetResolver;
        this.implicitSelectionSpec = implicitSelectionSpec;
    }

    private SelectedArtifactResults getSelectedArtifacts() {
        if (this.artifactsForThisConfiguration == null) {
            this.artifactsForThisConfiguration = this.artifactResults.selectLegacy(this.implicitSelectionSpec);
        }
        return this.artifactsForThisConfiguration;
    }

    @Override
    public ArtifactSelectionSpec getImplicitSelectionSpec() {
        return this.implicitSelectionSpec;
    }

    public Set<UnresolvedDependency> getUnresolvedModuleDependencies() {
        return this.graphResults.getUnresolvedDependencies();
    }

    private TransientConfigurationResults loadTransientGraphResults() {
        return this.legacyArtifactResultsLoader.apply(this.getSelectedArtifacts());
    }

    public ImmutableSet<ResolvedDependency> getFirstLevelModuleDependencies() {
        return this.loadTransientGraphResults().getFirstLevelDependencies();
    }

    public Set<ResolvedDependency> getAllModuleDependencies() {
        LinkedHashSet<ResolvedDependency> resolvedElements = new LinkedHashSet<ResolvedDependency>();
        LinkedList workQueue = new LinkedList(this.loadTransientGraphResults().getRootNode().getChildren());
        while (!workQueue.isEmpty()) {
            ResolvedDependency item = (ResolvedDependency)workQueue.removeFirst();
            if (!resolvedElements.add(item)) continue;
            Set children = item.getChildren();
            workQueue.addAll(children);
        }
        return resolvedElements;
    }

    public Set<ResolvedArtifact> getArtifacts() {
        LenientArtifactCollectingVisitor visitor = new LenientArtifactCollectingVisitor();
        this.artifactSetResolver.visitArtifacts(this.getSelectedArtifacts().getArtifacts(), visitor, this.resolutionHost);
        this.resolutionHost.rethrowFailuresAndReportProblems("artifacts", visitor.getFailures());
        return visitor.artifacts;
    }

    private static class LenientArtifactCollectingVisitor
    implements ArtifactVisitor {
        private final Set<ResolvedArtifact> artifacts = new LinkedHashSet<ResolvedArtifact>();
        private @Nullable List<Throwable> failures;

        private LenientArtifactCollectingVisitor() {
        }

        @Override
        public void visitArtifact(DisplayName artifactSetName, VariantIdentifier sourceVariantId, ImmutableAttributes attributes, ImmutableCapabilities capabilities, ResolvableArtifact artifact) {
            try {
                ResolvedArtifact resolvedArtifact = artifact.toPublicView();
                resolvedArtifact.getFile();
                this.artifacts.add(resolvedArtifact);
            }
            catch (ArtifactResolveException resolvedArtifact) {
            }
            catch (Exception e) {
                this.visitFailure(e);
            }
        }

        @Override
        public FileCollectionStructureVisitor.VisitType prepareForVisit(FileCollectionInternal.Source source) {
            if (source instanceof LocalDependencyFiles) {
                return FileCollectionStructureVisitor.VisitType.NoContents;
            }
            return FileCollectionStructureVisitor.VisitType.Visit;
        }

        @Override
        public boolean requireArtifactFiles() {
            return false;
        }

        @Override
        public void visitFailure(Throwable failure) {
            if (this.failures == null) {
                this.failures = new ArrayList<Throwable>();
            }
            this.failures.add(failure);
        }

        public List<Throwable> getFailures() {
            return this.failures != null ? this.failures : Collections.emptyList();
        }
    }
}

