/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.filemode;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;

class FNodeModel
extends NodeModel {
    private final File file;
    private final File[] directoryFiles;
    private boolean hasChildren = false;
    private boolean hasNoChildren = false;

    public FNodeModel(File file, MapModel map) {
        super(map);
        this.file = file;
        this.directoryFiles = null;
        String[] children = file.list();
        this.setFolded(children != null && children.length > 0);
    }

    public FNodeModel(File[] directoryFiles, MapModel map) {
        super(map);
        this.file = null;
        this.directoryFiles = directoryFiles;
        this.setFolded(directoryFiles.length > 0);
    }

    public List<NodeModel> getChildren() {
        this.initializeChildNodes();
        return super.getChildren();
    }

    private void initializeChildNodes() {
        if (super.getChildrenInternal().isEmpty() && this.hasChildren()) {
            try {
                File[] files;
                File[] fileArray = files = this.file != null ? this.file.listFiles() : this.directoryFiles;
                if (files != null) {
                    int childCount = 0;
                    for (File childFile : files) {
                        if (childFile.isHidden() && this.file != null) continue;
                        MapModel map = this.getMap();
                        FNodeModel fileNodeModel = new FNodeModel(childFile, map);
                        NodeLinks.createLinkExtension((NodeModel)fileNodeModel).setHyperLink(new Hyperlink(childFile.toURI()));
                        super.getChildrenInternal().add(childCount, fileNodeModel);
                        ++childCount;
                        fileNodeModel.setParent(this);
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public Object getUserObject() {
        if (this.file == null) {
            return "Files";
        }
        String name = this.file.getName();
        if (name.equals("")) {
            name = this.file.getPath();
        }
        return name;
    }

    public int getChildCount() {
        if (this.directoryFiles != null) {
            return this.directoryFiles.length;
        }
        if (this.hasChildren()) {
            this.initializeChildNodes();
            return super.getChildCount();
        }
        return 0;
    }

    protected List<NodeModel> getChildrenInternal() {
        this.initializeChildNodes();
        return super.getChildrenInternal();
    }

    public boolean hasChildren() {
        if (this.hasChildren) {
            return true;
        }
        if (this.hasNoChildren) {
            return false;
        }
        if (this.directoryFiles != null || this.containsFiles()) {
            this.hasChildren = true;
            return true;
        }
        this.hasNoChildren = true;
        return false;
    }

    private boolean containsFiles() {
        boolean bl;
        block9: {
            if (this.file.isFile()) {
                return false;
            }
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(this.file.toURI()));
            try {
                bl = dirStream.iterator().hasNext();
                if (dirStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (dirStream != null) {
                        try {
                            dirStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            dirStream.close();
        }
        return bl;
    }

    public String toString() {
        return this.getText();
    }
}

