/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

import org.apache.fontbox.cmap.CMap;

class CIDRange {
    private final int from;
    private int to;
    private final int unicode;
    private final int codeLength;

    CIDRange(int from, int to, int unicode, int codeLength) {
        this.from = from;
        this.to = to;
        this.unicode = unicode;
        this.codeLength = codeLength;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public int map(byte[] bytes) {
        int ch;
        if (bytes.length == this.codeLength && this.from <= (ch = CMap.toInt(bytes)) && ch <= this.to) {
            return this.unicode + (ch - this.from);
        }
        return -1;
    }

    public int map(int code, int length) {
        if (length == this.codeLength && this.from <= code && code <= this.to) {
            return this.unicode + (code - this.from);
        }
        return -1;
    }

    public int unmap(int code) {
        if (this.unicode <= code && code <= this.unicode + (this.to - this.from)) {
            return this.from + (code - this.unicode);
        }
        return -1;
    }

    public boolean extend(int newFrom, int newTo, int newCid, int length) {
        if (this.codeLength == length && newFrom == this.to + 1 && newCid == this.unicode + this.to - this.from + 1) {
            this.to = newTo;
            return true;
        }
        return false;
    }
}

