/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.dialog;

import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.dialog.FreeColInputDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.model.StringTemplate;

public final class SelectTributeAmountDialog
extends FreeColInputDialog<Integer> {
    private static final Logger logger = Logger.getLogger(SelectTributeAmountDialog.class.getName());
    private static final int COLUMNS = 5;
    private final JTextField input;
    private final int maximum;

    public SelectTributeAmountDialog(FreeColClient freeColClient, JFrame frame, StringTemplate question, int maximum) {
        super(freeColClient, frame);
        this.maximum = maximum;
        this.input = new JTextField(Integer.toString(maximum), 5);
        MigPanel panel = new MigPanel(new MigLayout("wrap 1"));
        panel.add(Utility.localizedTextArea(question));
        panel.add(this.input);
        panel.setSize(panel.getPreferredSize());
        this.initializeInputDialog(frame, true, panel, null, "ok", "cancel");
    }

    @Override
    protected Integer getInputValue() {
        int result;
        try {
            result = Integer.parseInt(this.input.getText());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return result <= 0 || result > this.maximum ? null : Integer.valueOf(result);
    }

    @Override
    public void requestFocus() {
        this.input.requestFocus();
    }
}

