/*******************************************************************************

    uBlock Origin - a comprehensive, efficient content blocker
    Copyright (C) 2014-present Raymond Hill

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see {http://www.gnu.org/licenses/}.

    Home: https://github.com/gorhill/uBlock
*/

import DynamicHostRuleFiltering from './dynamic-net-filtering.js';
import DynamicSwitchRuleFiltering from './hnswitches.js';
import DynamicURLRuleFiltering from './url-net-filtering.js';

/******************************************************************************/

const permanentFirewall = new DynamicHostRuleFiltering();
const sessionFirewall = new DynamicHostRuleFiltering();

const permanentURLFiltering = new DynamicURLRuleFiltering();
const sessionURLFiltering = new DynamicURLRuleFiltering();

const permanentSwitches = new DynamicSwitchRuleFiltering();
const sessionSwitches = new DynamicSwitchRuleFiltering();

/******************************************************************************/

export {
    permanentFirewall,
    sessionFirewall,
    permanentURLFiltering,
    sessionURLFiltering,
    permanentSwitches,
    sessionSwitches,
};
