/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest.fst;

import java.nio.charset.StandardCharsets;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.FreeTextSuggester;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.FieldType;
import org.apache.solr.spelling.suggest.LookupFactory;

public class FreeTextLookupFactory
extends LookupFactory {
    public static final String QUERY_ANALYZER = "suggestFreeTextAnalyzerFieldType";
    public static final String NGRAMS = "ngrams";
    public static final String SEPARATOR = "separator";
    private static final String FILENAME = "ftsta.bin";

    @Override
    public Lookup create(NamedList<?> params, SolrCore core) {
        Object fieldTypeName = params.get(QUERY_ANALYZER);
        if (fieldTypeName == null) {
            throw new IllegalArgumentException("Error in configuration: suggestFreeTextAnalyzerFieldType parameter is mandatory");
        }
        FieldType ft = core.getLatestSchema().getFieldTypeByName(fieldTypeName.toString());
        if (ft == null) {
            throw new IllegalArgumentException("Error in configuration: " + fieldTypeName.toString() + " is not defined in the schema");
        }
        Analyzer indexAnalyzer = ft.getIndexAnalyzer();
        Analyzer queryAnalyzer = ft.getQueryAnalyzer();
        int grams = params.get(NGRAMS) != null ? Integer.parseInt(params.get(NGRAMS).toString()) : 2;
        byte separator = params.get(SEPARATOR) != null ? params.get(SEPARATOR).toString().getBytes(StandardCharsets.UTF_8)[0] : (byte)30;
        return new FreeTextSuggester(indexAnalyzer, queryAnalyzer, grams, separator);
    }

    @Override
    public String storeFileName() {
        return FILENAME;
    }
}

