/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkRenyiEntropyThresholdImageFilter_h
#define sitkRenyiEntropyThresholdImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class RenyiEntropyThresholdImageFilter
\brief Threshold an image using the RenyiEntropy Threshold.

This filter creates a binary thresholded image that separates an image into foreground and background components. The filter computes the threshold using the RenyiEntropyThresholdCalculator and applies that threshold to the input image using the BinaryThresholdImageFilter .

\author Richard Beare. Department of Medicine, Monash University, Melbourne, Australia. 


\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.


This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/efycla 

\see HistogramThresholdImageFilter
\sa itk::simple::RenyiEntropyThreshold for the procedural interface
\sa itk::RenyiEntropyThresholdImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT RenyiEntropyThresholdImageFilter : public ImageFilter {
    public:
      using Self = RenyiEntropyThresholdImageFilter;

      /** Destructor */
      virtual ~RenyiEntropyThresholdImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      RenyiEntropyThresholdImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * Set the "inside" pixel value.

       */
      SITK_RETURN_SELF_TYPE_HEADER SetInsideValue ( uint8_t InsideValue ) { this->m_InsideValue = InsideValue; return *this; }

      /**
       * Get the "inside" pixel value.

       */
      uint8_t GetInsideValue() const { return this->m_InsideValue; }\

      /**
       * Set the "outside" pixel value. The default value NumericTraits<OutputPixelType>::Zero.

       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutsideValue ( uint8_t OutsideValue ) { this->m_OutsideValue = OutsideValue; return *this; }

      /**
       * Get the "outside" pixel value.

       */
      uint8_t GetOutsideValue() const { return this->m_OutsideValue; }\

      /**
       * Set/Get the number of histogram bins.

       */
      SITK_RETURN_SELF_TYPE_HEADER SetNumberOfHistogramBins ( uint32_t NumberOfHistogramBins ) { this->m_NumberOfHistogramBins = NumberOfHistogramBins; return *this; }

      /**
       */
      uint32_t GetNumberOfHistogramBins() const { return this->m_NumberOfHistogramBins; }\

      /**
       * Do you want the output to be masked by the mask used in histogram construction. Only relevant if masking is in use.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetMaskOutput ( bool MaskOutput ) { this->m_MaskOutput = MaskOutput; return *this; }

      /** Set the value of MaskOutput to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER MaskOutputOn() { return this->SetMaskOutput(true); }
      SITK_RETURN_SELF_TYPE_HEADER MaskOutputOff() { return this->SetMaskOutput(false); }

      /**
       */
      bool GetMaskOutput() const { return this->m_MaskOutput; }\

      /**
       * The value in the mask image, if used, indicating voxels that should be included. Default is the max of pixel type, as in the MaskedImageToHistogramFilter
       */
      SITK_RETURN_SELF_TYPE_HEADER SetMaskValue ( uint8_t MaskValue ) { this->m_MaskValue = MaskValue; return *this; }

      /**
       */
      uint8_t GetMaskValue() const { return this->m_MaskValue; }
     /** \brief Get the computed threshold.
      *
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetThreshold() const { return this->m_Threshold; };


      /** Name of this class */
      std::string GetName() const { return std::string ("RenyiEntropyThresholdImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image & image, const Image & maskImage );
      Image Execute ( const Image & image );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image * image, const Image * maskImage );
      template <class TImageType> Image ExecuteInternal ( const Image * image, const Image * maskImage );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      uint8_t  m_InsideValue{1u};

      uint8_t  m_OutsideValue{0u};

      uint32_t  m_NumberOfHistogramBins{256u};

      bool  m_MaskOutput{true};

      uint8_t  m_MaskValue{255u};

      /* Docs */
      double m_Threshold{0.0};


    };

    /**\
     * \brief Threshold an image using the RenyiEntropy Threshold.
     *
     * This function directly calls the execute method of RenyiEntropyThresholdImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::RenyiEntropyThresholdImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image RenyiEntropyThreshold ( const Image & image, const Image & maskImage, uint8_t insideValue = 1u, uint8_t outsideValue = 0u, uint32_t numberOfHistogramBins = 256u, bool maskOutput = true, uint8_t maskValue = 255u );
     SITKBasicFilters_EXPORT Image RenyiEntropyThreshold ( const Image & image, uint8_t insideValue = 1u, uint8_t outsideValue = 0u, uint32_t numberOfHistogramBins = 256u, bool maskOutput = true, uint8_t maskValue = 255u );
     /** @} */
}
#endif
