/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.repository;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.api.RuntimeGroup;
import com.ibm.db2.cmx.runtime.internal.repository.api.RuntimeGroupManager;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ManageRepositoryUtility {
    private static final String newLine__ = System.getProperty("line.separator");
    private static final int lineLength__ = 80;

    public static boolean runtimeGroupExists(String string, RuntimeGroupManager runtimeGroupManager) throws MetadataException {
        List<RuntimeGroup> list = runtimeGroupManager.list();
        for (RuntimeGroup runtimeGroup : list) {
            if (!runtimeGroup.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean runtimeGroupVersionExists(String string, String string2, RuntimeGroupManager runtimeGroupManager) throws MetadataException {
        List<RuntimeGroup> list = runtimeGroupManager.list();
        for (RuntimeGroup runtimeGroup : list) {
            if (!runtimeGroup.getName().equals(string) || !runtimeGroup.getVersion().equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getRuntimeGroupVersions(String string, RuntimeGroupManager runtimeGroupManager, PrintWriter printWriter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            List<RuntimeGroup> list = runtimeGroupManager.list();
            for (RuntimeGroup runtimeGroup : list) {
                if (!runtimeGroup.getName().equals(string)) continue;
                if (runtimeGroup.isActive()) {
                    arrayList.add(runtimeGroup.getVersion() + " " + Messages.getText("MSG_RUNTIME_GROUP_ACTIVE", new Object[0]));
                    continue;
                }
                arrayList.add(runtimeGroup.getVersion());
            }
        }
        catch (MetadataException metadataException) {
            String string2 = metadataException.getMessage();
            printWriter.println(string2);
        }
        return arrayList;
    }

    public static void addPureQueryData(String string, String string2, String string3, String string4, String string5, String string6, String string7, RuntimeGroupManager runtimeGroupManager, RepositoryVersion repositoryVersion) throws MetadataException, IOException {
        ManageRepositoryUtility.setData(runtimeGroupManager, string, string2, string7, string4, RuntimeGroupManager.MemberType.PDQXML);
        if (!ManageRepositoryUtility.isOPMRepository(repositoryVersion)) {
            ManageRepositoryUtility.setData(runtimeGroupManager, string, string2, string7, string3, RuntimeGroupManager.MemberType.PdqProps);
            ManageRepositoryUtility.setData(runtimeGroupManager, string, string2, string7, string5, RuntimeGroupManager.MemberType.BindProps);
            ManageRepositoryUtility.setData(runtimeGroupManager, string, string2, string7, string6, RuntimeGroupManager.MemberType.GenProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setData(RuntimeGroupManager runtimeGroupManager, String string, String string2, String string3, String string4, RuntimeGroupManager.MemberType memberType) throws IOException, MetadataException {
        if (string4 == null) {
            return;
        }
        String string5 = ManageRepositoryUtility.getInputFilename(string3, string4);
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(string5);
            runtimeGroupManager.setData(string, string2, fileInputStream, memberType, string5);
        }
    }

    private static String getInputFilename(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (!string.endsWith(File.separator)) {
            return string + File.separator + string2;
        }
        return string + string2;
    }

    private static String addLinebreaks(String string, int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n3 = 0;
        boolean bl2 = false;
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("--")) {
                bl2 = true;
            }
            stringBuilder.append(string2 + " ");
            n3 = n3 + string2.length() + 1;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (n3 + string2.length() > n2) {
                    stringBuilder.append(newLine__);
                    n3 = 0;
                    if (bl2) {
                        stringBuilder.append("-- ");
                        n3 = 3;
                    }
                }
                stringBuilder.append(string2);
                if ((n3 += string2.length()) >= n2) continue;
                stringBuilder.append(" ");
                ++n3;
            }
        }
        return stringBuilder.toString();
    }

    public static void writeCommandScript(List<String> list, Writer writer, DatabaseMetaData databaseMetaData) throws SQLException {
        Iterator<String> iterator = list.iterator();
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
        String string = databaseMetaData.getURL();
        String string2 = databaseMetaData.getDatabaseProductName();
        String string3 = "";
        String string4 = "";
        string = "-- URL: " + string;
        string2 = "-- DatabaseProductName: " + string2 + "\n";
        string3 = string.length() > 80 ? ManageRepositoryUtility.addLinebreaks(string, 80) : string3 + string;
        printWriter.println(string3);
        string4 = string2.length() > 80 ? ManageRepositoryUtility.addLinebreaks(string2, 80) : string4 + string2;
        printWriter.println(string4);
        String string5 = "";
        String string6 = "";
        Pattern pattern = Pattern.compile("\\s+");
        while (iterator.hasNext()) {
            String string7 = "";
            string5 = iterator.next();
            Matcher matcher = pattern.matcher(string5);
            string6 = matcher.replaceAll(" ");
            string7 = string6.length() > 80 ? ManageRepositoryUtility.addLinebreaks(string6, 80) : string7 + string6;
            printWriter.println(string7);
            printWriter.println();
        }
        printWriter.close();
    }

    public static void displayExceptionMessages(PrintWriter printWriter, Exception exception) {
        Throwable throwable = exception;
        while (throwable != null) {
            if (throwable != exception) {
                printWriter.println("caused by, ");
            }
            printWriter.println(throwable.getClass().getSimpleName() + ": " + throwable.getMessage());
            if (throwable.getCause() != throwable) {
                throwable = throwable.getCause();
                continue;
            }
            throwable = null;
        }
    }

    public static boolean isOPMRepository(RepositoryVersion repositoryVersion) throws MetadataException {
        boolean bl2 = repositoryVersion.compareTo(RepositoryVersion.OPMVersion) <= 0;
        return bl2;
    }

    public static void validateOptionForOPM(String string, PossibleArgs possibleArgs, PrintWriter printWriter) {
        if (string != null) {
            String string2 = Messages.getText("WARN_OPTIONS_IGNORED", new Object[]{possibleArgs}) + ". " + Messages.getText("MSG_OPTION_NOT_SUPPORTED_FOR_OPM_REPOSITORY", new Object[0]);
            printWriter.println(string2);
        }
    }

    public static String getActiveVersion(String string, RuntimeGroupManager runtimeGroupManager) {
        try {
            List<RuntimeGroup> list = runtimeGroupManager.list();
            for (RuntimeGroup runtimeGroup : list) {
                if (!runtimeGroup.getName().equals(string) || !runtimeGroup.isActive()) continue;
                return runtimeGroup.getVersion();
            }
        }
        catch (MetadataException metadataException) {
            return null;
        }
        return null;
    }

    public static boolean isRuntimeGroupActive(String string, RuntimeGroupManager runtimeGroupManager) throws MetadataException {
        List<RuntimeGroup> list = runtimeGroupManager.list();
        for (RuntimeGroup runtimeGroup : list) {
            if (!runtimeGroup.getName().equals(string) || !runtimeGroup.isActive()) continue;
            return true;
        }
        return false;
    }
}

