/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.ints.PInt;

public class MathGuards {
    public static boolean fitLong(double value) {
        return -9.223372036854776E18 < value && value < 9.223372036854776E18;
    }

    public static boolean fitInt(double value) {
        return -2.147483648E9 <= value && value <= 2.147483647E9;
    }

    public static boolean isNumber(Object value) {
        return MathGuards.isInteger(value) || value instanceof Float || value instanceof Double || value instanceof PFloat;
    }

    public static boolean isComplexNumber(Object value) {
        return MathGuards.isNumber(value) || value instanceof PComplex;
    }

    public static boolean isInteger(Object value) {
        return value instanceof Integer || value instanceof Long || value instanceof PInt || value instanceof Boolean;
    }

    public static boolean isFloat(Object value) {
        return value instanceof Double || value instanceof PFloat;
    }
}

