/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DateCommonBinder;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.TimestampCopyingBinder;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.Datum;

class TimestampBinder
extends DateCommonBinder {
    Binder theTimestampCopyingBinder = null;
    Timestamp paramVal;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    static void init(Binder x2, int _scale) {
        x2.type = (short)180;
        x2.bytelen = 11;
        x2.scale = (short)_scale;
    }

    TimestampBinder(Timestamp x2) {
        TimestampBinder.init(this, -1);
        this.paramVal = x2;
    }

    TimestampBinder(Timestamp x2, int _scale) {
        TimestampBinder.init(this, _scale);
        this.paramVal = x2;
    }

    @Override
    Binder copyingBinder() {
        if (this.theTimestampCopyingBinder == null) {
            this.theTimestampCopyingBinder = new TimestampCopyingBinder();
        }
        return this.theTimestampCopyingBinder;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        Timestamp value = this.paramVal;
        byte[] b2 = null;
        int offset = 0;
        int len = 0;
        long pos = 0L;
        if (clearPriorBindValues) {
            this.paramVal = null;
        }
        if (value == null) {
            bindIndicators[indoffset] = -1;
            if (bindUseDBA) {
                bindDataOffsets[bindDataIndex] = -1L;
                bindDataLengths[bindDataIndex] = 0;
            }
        } else {
            if (bindUseDBA) {
                bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
                stmt.lastBoundDataOffsets[bindPosition] = pos;
                b2 = stmt.connection.methodTempLittleByteBuffer;
                byteoffset = 0;
                offset = 0;
            } else {
                b2 = bindBytes;
                offset = byteoffset;
            }
            bindIndicators[indoffset] = 0;
            len = this.getDatumBytes(stmt, value, b2, offset, bindUseDBA, bytePitch);
        }
        if (bindUseDBA) {
            bindData.put(b2, 0, len);
            bindIndicators[indoffset] = 0;
            bindDataLengths[bindDataIndex] = len;
            stmt.lastBoundDataLengths[bindPosition] = len;
            bindIndicators[lenoffset] = (short)len;
        } else {
            bindIndicators[indoffset] = 0;
            bindIndicators[lenoffset] = (short)len;
        }
        if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
            localCheckSum = bindIndicators[indoffset] == -1 ? CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length) : CRC64.updateChecksum(localCheckSum, value.getTime());
        }
        return localCheckSum;
    }

    private int getDatumBytes(OraclePreparedStatement stmt, Timestamp value, byte[] b2, int offset, boolean bindUseDBA, int bytePitch) throws SQLException {
        int len = 0;
        TimestampBinder.setOracleHMS(TimestampBinder.setOracleCYMD(value.getTime(), b2, offset, stmt), b2, offset);
        int nanos = value.getNanos();
        if (nanos != 0) {
            TimestampBinder.setOracleNanos(nanos, b2, offset);
            len = bindUseDBA ? 11 : bytePitch;
        } else {
            len = 7;
        }
        return len;
    }

    @Override
    Datum getDatum(OraclePreparedStatement stmt, int bindPosition, int formOfUse, int internalType) throws SQLException {
        byte[] b2 = stmt.connection.methodTempLittleByteBuffer;
        int len = this.getDatumBytes(stmt, this.paramVal, b2, 0, true, 0);
        return SQLUtil.makeDatum((OracleConnection)stmt.connection, Arrays.copyOf(b2, len), internalType, null, 0);
    }

    static {
        try {
            $$$methodRef$$$6 = TimestampBinder.class.getDeclaredConstructor(Timestamp.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TimestampBinder.class.getDeclaredConstructor(Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TimestampBinder.class.getDeclaredMethod("getDatum", OraclePreparedStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TimestampBinder.class.getDeclaredMethod("getDatumBytes", OraclePreparedStatement.class, Timestamp.class, byte[].class, Integer.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TimestampBinder.class.getDeclaredMethod("bind", OraclePreparedStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, char[].class, short[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Long.TYPE, ByteArray.class, long[].class, int[].class, Integer.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TimestampBinder.class.getDeclaredMethod("copyingBinder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TimestampBinder.class.getDeclaredMethod("init", Binder.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

