/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.json.async;

import java.io.IOException;
import java.io.OutputStream;
import tools.jackson.core.JacksonException;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.async.ByteArrayFeeder;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.json.async.NonBlockingUtf8JsonParserBase;
import tools.jackson.core.sym.ByteQuadsCanonicalizer;

public class NonBlockingByteArrayJsonParser
extends NonBlockingUtf8JsonParserBase
implements ByteArrayFeeder {
    private byte[] _inputBuffer = NO_BYTES;

    public NonBlockingByteArrayJsonParser(ObjectReadContext readCtxt, IOContext ctxt, int stdFeatures, int formatReadFeatures, ByteQuadsCanonicalizer sym) {
        super(readCtxt, ctxt, stdFeatures, formatReadFeatures, sym);
    }

    @Override
    public ByteArrayFeeder nonBlockingInputFeeder() {
        return this;
    }

    @Override
    public void feedInput(byte[] buf, int start, int end) throws JacksonException {
        if (this._inputPtr < this._inputEnd) {
            this._reportError("Still have %d undecoded bytes, should not call 'feedInput'", this._inputEnd - this._inputPtr);
        }
        if (end < start) {
            this._reportError("Input end (%d) may not be before start (%d)", end, start);
        }
        if (this._endOfInput) {
            this._reportError("Already closed, cannot feed more input");
        }
        this._currInputProcessed += (long)this._origBufferLen;
        this._streamReadConstraints.validateDocumentLength(this._currInputProcessed);
        this._currInputRowStart = start - (this._inputEnd - this._currInputRowStart);
        this._currBufferStart = start;
        this._inputBuffer = buf;
        this._inputPtr = start;
        this._inputEnd = end;
        this._origBufferLen = end - start;
    }

    @Override
    public int releaseBuffered(OutputStream out) throws JacksonException {
        int avail = this._inputEnd - this._inputPtr;
        if (avail > 0) {
            try {
                out.write(this._inputBuffer, this._inputPtr, avail);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        }
        return avail;
    }

    @Override
    protected byte getNextSignedByteFromBuffer() {
        return this._inputBuffer[this._inputPtr++];
    }

    @Override
    protected int getNextUnsignedByteFromBuffer() {
        return this._inputBuffer[this._inputPtr++] & 0xFF;
    }

    @Override
    protected byte getByteFromBuffer(int ptr) {
        return this._inputBuffer[ptr];
    }
}

