# value_switch_row.py
#
# Copyright 2024 Evelyn Serra (itsEve)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later

from typing import Any

from gi.repository import Gtk

from refine.widgets.string_row import StringRow


@Gtk.Template.from_resource("/page/tesk/Refine/widgets/value-switch-row.ui")
class ValueSwitchRow(StringRow):
    """A `StringRow` to enable or disable a feature from a combo action."""

    __gtype_name__ = "ValueSwitchRow"

    def get_string(self) -> str:
        """Retrieve string from key."""
        return self.settings.get_string(self.key)

    def active_set(self, *_args: Any) -> None:
        """Set whether @self is in its “on” or “off” position."""
        self.do_update()
        if self.active:
            self.settings.set_string(self.key, self.value)
        else:
            self.settings.reset(self.key)

        self.value_set(self.settings.get_string(self.key))
