/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.builder;

import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;

public final class ClientBuilderUtil {
    private static final ClientLogger LOGGER = new ClientLogger(ClientBuilderUtil.class);
    private static final RetryPolicy DEFAULT_RETRY_POLICY = new RetryPolicy();

    private ClientBuilderUtil() {
    }

    public static HttpPipelinePolicy validateAndGetRetryPolicy(HttpPipelinePolicy retryPolicy, RetryOptions retryOptions) {
        return ClientBuilderUtil.validateAndGetRetryPolicy(retryPolicy, retryOptions, DEFAULT_RETRY_POLICY);
    }

    public static HttpPipelinePolicy validateAndGetRetryPolicy(HttpPipelinePolicy retryPolicy, RetryOptions retryOptions, HttpPipelinePolicy defaultPolicy) {
        Objects.requireNonNull(defaultPolicy, "'defaultPolicy' cannot be null.");
        if (retryPolicy != null && retryOptions != null) {
            throw LOGGER.logExceptionAsWarning(new IllegalStateException("'retryPolicy' and 'retryOptions' cannot both be set"));
        }
        if (retryPolicy != null) {
            return retryPolicy;
        }
        if (retryOptions != null) {
            return new RetryPolicy(retryOptions);
        }
        return defaultPolicy;
    }
}

