/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardPath
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardPath> {
    @Nonnull
    private final String dataPath;
    private final boolean isCustomDataPath;
    @Nonnull
    private final String statePath;
    public static final JsonpDeserializer<ShardPath> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardPath::setupShardPathDeserializer);

    private ShardPath(Builder builder) {
        this.dataPath = ApiTypeHelper.requireNonNull(builder.dataPath, this, "dataPath");
        this.isCustomDataPath = ApiTypeHelper.requireNonNull(builder.isCustomDataPath, this, "isCustomDataPath");
        this.statePath = ApiTypeHelper.requireNonNull(builder.statePath, this, "statePath");
    }

    public static ShardPath of(Function<Builder, ObjectBuilder<ShardPath>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String dataPath() {
        return this.dataPath;
    }

    public final boolean isCustomDataPath() {
        return this.isCustomDataPath;
    }

    @Nonnull
    public final String statePath() {
        return this.statePath;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("data_path");
        generator.write(this.dataPath);
        generator.writeKey("is_custom_data_path");
        generator.write(this.isCustomDataPath);
        generator.writeKey("state_path");
        generator.write(this.statePath);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardPathDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataPath, JsonpDeserializer.stringDeserializer(), "data_path");
        op.add(Builder::isCustomDataPath, JsonpDeserializer.booleanDeserializer(), "is_custom_data_path");
        op.add(Builder::statePath, JsonpDeserializer.stringDeserializer(), "state_path");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.dataPath.hashCode();
        result = 31 * result + Boolean.hashCode(this.isCustomDataPath);
        result = 31 * result + this.statePath.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardPath other = (ShardPath)o;
        return this.dataPath.equals(other.dataPath) && this.isCustomDataPath == other.isCustomDataPath && this.statePath.equals(other.statePath);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardPath> {
        private String dataPath;
        private Boolean isCustomDataPath;
        private String statePath;

        public Builder() {
        }

        private Builder(ShardPath o) {
            this.dataPath = o.dataPath;
            this.isCustomDataPath = o.isCustomDataPath;
            this.statePath = o.statePath;
        }

        private Builder(Builder o) {
            this.dataPath = o.dataPath;
            this.isCustomDataPath = o.isCustomDataPath;
            this.statePath = o.statePath;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder dataPath(String value) {
            this.dataPath = value;
            return this;
        }

        @Nonnull
        public final Builder isCustomDataPath(boolean value) {
            this.isCustomDataPath = value;
            return this;
        }

        @Nonnull
        public final Builder statePath(String value) {
            this.statePath = value;
            return this;
        }

        @Override
        @Nonnull
        public ShardPath build() {
            this._checkSingleUse();
            return new ShardPath(this);
        }
    }
}

