/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.search.LaplaceSmoothingModel;
import org.opensearch.client.opensearch.core.search.LinearInterpolationSmoothingModel;
import org.opensearch.client.opensearch.core.search.SmoothingModelVariant;
import org.opensearch.client.opensearch.core.search.StupidBackoffSmoothingModel;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class SmoothingModel
implements TaggedUnion<Kind, SmoothingModelVariant>,
PlainJsonSerializable {
    private final Kind _kind;
    private final SmoothingModelVariant _value;
    public static final JsonpDeserializer<SmoothingModel> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SmoothingModel::setupSmoothingModelDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final SmoothingModelVariant _get() {
        return this._value;
    }

    public SmoothingModel(SmoothingModelVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._smoothingModelKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private SmoothingModel(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static SmoothingModel of(Function<Builder, ObjectBuilder<SmoothingModel>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isLaplace() {
        return this._kind == Kind.Laplace;
    }

    public LaplaceSmoothingModel laplace() {
        return (LaplaceSmoothingModel)TaggedUnionUtils.get(this, Kind.Laplace);
    }

    public boolean isLinearInterpolation() {
        return this._kind == Kind.LinearInterpolation;
    }

    public LinearInterpolationSmoothingModel linearInterpolation() {
        return (LinearInterpolationSmoothingModel)TaggedUnionUtils.get(this, Kind.LinearInterpolation);
    }

    public boolean isStupidBackoff() {
        return this._kind == Kind.StupidBackoff;
    }

    public StupidBackoffSmoothingModel stupidBackoff() {
        return (StupidBackoffSmoothingModel)TaggedUnionUtils.get(this, Kind.StupidBackoff);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)((Object)this._value)).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSmoothingModelDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::laplace, LaplaceSmoothingModel._DESERIALIZER, "laplace");
        op.add(Builder::linearInterpolation, LinearInterpolationSmoothingModel._DESERIALIZER, "linear_interpolation");
        op.add(Builder::stupidBackoff, StupidBackoffSmoothingModel._DESERIALIZER, "stupid_backoff");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmoothingModel other = (SmoothingModel)o;
        return Objects.equals(this._kind, other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SmoothingModel> {
        private Kind _kind;
        private SmoothingModelVariant _value;

        public Builder() {
        }

        private Builder(SmoothingModel o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<SmoothingModel> laplace(LaplaceSmoothingModel v) {
            this._kind = Kind.Laplace;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SmoothingModel> laplace(Function<LaplaceSmoothingModel.Builder, ObjectBuilder<LaplaceSmoothingModel>> fn) {
            return this.laplace(fn.apply(new LaplaceSmoothingModel.Builder()).build());
        }

        public ObjectBuilder<SmoothingModel> linearInterpolation(LinearInterpolationSmoothingModel v) {
            this._kind = Kind.LinearInterpolation;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SmoothingModel> linearInterpolation(Function<LinearInterpolationSmoothingModel.Builder, ObjectBuilder<LinearInterpolationSmoothingModel>> fn) {
            return this.linearInterpolation(fn.apply(new LinearInterpolationSmoothingModel.Builder()).build());
        }

        public ObjectBuilder<SmoothingModel> stupidBackoff(StupidBackoffSmoothingModel v) {
            this._kind = Kind.StupidBackoff;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SmoothingModel> stupidBackoff(Function<StupidBackoffSmoothingModel.Builder, ObjectBuilder<StupidBackoffSmoothingModel>> fn) {
            return this.stupidBackoff(fn.apply(new StupidBackoffSmoothingModel.Builder()).build());
        }

        @Override
        public SmoothingModel build() {
            this._checkSingleUse();
            return new SmoothingModel(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Laplace("laplace"),
        LinearInterpolation("linear_interpolation"),
        StupidBackoff("stupid_backoff");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

