/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.FunctionBoostMode;
import org.opensearch.client.opensearch._types.query_dsl.FunctionScore;
import org.opensearch.client.opensearch._types.query_dsl.FunctionScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class FunctionScoreQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, FunctionScoreQuery> {
    @Nullable
    private final FunctionBoostMode boostMode;
    @Nonnull
    private final List<FunctionScore> functions;
    @Nullable
    private final Float maxBoost;
    @Nullable
    private final Float minScore;
    @Nullable
    private final Query query;
    @Nullable
    private final FunctionScoreMode scoreMode;
    public static final JsonpDeserializer<FunctionScoreQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FunctionScoreQuery::setupFunctionScoreQueryDeserializer);

    private FunctionScoreQuery(Builder builder) {
        super(builder);
        this.boostMode = builder.boostMode;
        this.functions = ApiTypeHelper.unmodifiable(builder.functions);
        this.maxBoost = builder.maxBoost;
        this.minScore = builder.minScore;
        this.query = builder.query;
        this.scoreMode = builder.scoreMode;
    }

    public static FunctionScoreQuery of(Function<Builder, ObjectBuilder<FunctionScoreQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.FunctionScore;
    }

    @Nullable
    public final FunctionBoostMode boostMode() {
        return this.boostMode;
    }

    @Nonnull
    public final List<FunctionScore> functions() {
        return this.functions;
    }

    @Nullable
    public final Float maxBoost() {
        return this.maxBoost;
    }

    @Nullable
    public final Float minScore() {
        return this.minScore;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final FunctionScoreMode scoreMode() {
        return this.scoreMode;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.boostMode != null) {
            generator.writeKey("boost_mode");
            this.boostMode.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.functions)) {
            generator.writeKey("functions");
            generator.writeStartArray();
            for (FunctionScore item0 : this.functions) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxBoost != null) {
            generator.writeKey("max_boost");
            generator.write((double)this.maxBoost.floatValue());
        }
        if (this.minScore != null) {
            generator.writeKey("min_score");
            generator.write((double)this.minScore.floatValue());
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.scoreMode != null) {
            generator.writeKey("score_mode");
            this.scoreMode.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupFunctionScoreQueryDeserializer(ObjectDeserializer<Builder> op) {
        FunctionScoreQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::boostMode, FunctionBoostMode._DESERIALIZER, "boost_mode");
        op.add(Builder::functions, JsonpDeserializer.arrayDeserializer(FunctionScore._DESERIALIZER), "functions");
        op.add(Builder::maxBoost, JsonpDeserializer.floatDeserializer(), "max_boost");
        op.add(Builder::minScore, JsonpDeserializer.floatDeserializer(), "min_score");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::scoreMode, FunctionScoreMode._DESERIALIZER, "score_mode");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.boostMode);
        result = 31 * result + Objects.hashCode(this.functions);
        result = 31 * result + Objects.hashCode(this.maxBoost);
        result = 31 * result + Objects.hashCode(this.minScore);
        result = 31 * result + Objects.hashCode(this.query);
        result = 31 * result + Objects.hashCode(this.scoreMode);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionScoreQuery other = (FunctionScoreQuery)o;
        return Objects.equals(this.boostMode, other.boostMode) && Objects.equals(this.functions, other.functions) && Objects.equals(this.maxBoost, other.maxBoost) && Objects.equals(this.minScore, other.minScore) && Objects.equals(this.query, other.query) && Objects.equals(this.scoreMode, other.scoreMode);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, FunctionScoreQuery> {
        @Nullable
        private FunctionBoostMode boostMode;
        @Nullable
        private List<FunctionScore> functions;
        @Nullable
        private Float maxBoost;
        @Nullable
        private Float minScore;
        @Nullable
        private Query query;
        @Nullable
        private FunctionScoreMode scoreMode;

        public Builder() {
        }

        private Builder(FunctionScoreQuery o) {
            super(o);
            this.boostMode = o.boostMode;
            this.functions = Builder._listCopy(o.functions);
            this.maxBoost = o.maxBoost;
            this.minScore = o.minScore;
            this.query = o.query;
            this.scoreMode = o.scoreMode;
        }

        private Builder(Builder o) {
            super(o);
            this.boostMode = o.boostMode;
            this.functions = Builder._listCopy(o.functions);
            this.maxBoost = o.maxBoost;
            this.minScore = o.minScore;
            this.query = o.query;
            this.scoreMode = o.scoreMode;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder boostMode(@Nullable FunctionBoostMode value) {
            this.boostMode = value;
            return this;
        }

        @Nonnull
        public final Builder functions(List<FunctionScore> list) {
            this.functions = Builder._listAddAll(this.functions, list);
            return this;
        }

        @Nonnull
        public final Builder functions(FunctionScore value, FunctionScore ... values) {
            this.functions = Builder._listAdd(this.functions, value, values);
            return this;
        }

        @Nonnull
        public final Builder functions(Function<FunctionScore.Builder, ObjectBuilder<FunctionScore>> fn) {
            return this.functions(fn.apply(new FunctionScore.Builder()).build(), new FunctionScore[0]);
        }

        @Nonnull
        public final Builder maxBoost(@Nullable Float value) {
            this.maxBoost = value;
            return this;
        }

        @Nonnull
        public final Builder minScore(@Nullable Float value) {
            this.minScore = value;
            return this;
        }

        @Nonnull
        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        @Nonnull
        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        @Nonnull
        public final Builder scoreMode(@Nullable FunctionScoreMode value) {
            this.scoreMode = value;
            return this;
        }

        @Override
        @Nonnull
        public FunctionScoreQuery build() {
            this._checkSingleUse();
            return new FunctionScoreQuery(this);
        }
    }
}

