/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.utils;

import java.net.IDN;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.annotation.Internal;

public class DnsUtils {
    private DnsUtils() {
    }

    private static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static String normalize(String s) {
        int remaining;
        if (s == null) {
            return null;
        }
        int pos = 0;
        for (remaining = s.length(); remaining > 0 && !DnsUtils.isUpper(s.charAt(pos)); --remaining) {
            ++pos;
        }
        if (remaining > 0) {
            StringBuilder buf = new StringBuilder(s.length());
            buf.append(s, 0, pos);
            while (remaining > 0) {
                char c = s.charAt(pos);
                if (DnsUtils.isUpper(c)) {
                    buf.append((char)(c + 32));
                } else {
                    buf.append(c);
                }
                ++pos;
                --remaining;
            }
            return buf.toString();
        }
        return s;
    }

    @Internal
    public static String normalizeUnicode(String s) {
        String decoded;
        if (s == null) {
            return null;
        }
        try {
            decoded = IDN.toUnicode(s);
        }
        catch (IllegalArgumentException ignore) {
            decoded = s;
        }
        return DnsUtils.normalize(decoded);
    }
}

