/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.RemoteStoreUploadDownloadStats;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RemoteStoreDownloadStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RemoteStoreDownloadStats> {
    @Nonnull
    private final RemoteStoreUploadDownloadStats totalDownloadSize;
    @Nullable
    private final Time totalTimeSpent;
    private final long totalTimeSpentInMillis;
    public static final JsonpDeserializer<RemoteStoreDownloadStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoteStoreDownloadStats::setupRemoteStoreDownloadStatsDeserializer);

    private RemoteStoreDownloadStats(Builder builder) {
        this.totalDownloadSize = ApiTypeHelper.requireNonNull(builder.totalDownloadSize, this, "totalDownloadSize");
        this.totalTimeSpent = builder.totalTimeSpent;
        this.totalTimeSpentInMillis = ApiTypeHelper.requireNonNull(builder.totalTimeSpentInMillis, this, "totalTimeSpentInMillis");
    }

    public static RemoteStoreDownloadStats of(Function<Builder, ObjectBuilder<RemoteStoreDownloadStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final RemoteStoreUploadDownloadStats totalDownloadSize() {
        return this.totalDownloadSize;
    }

    @Nullable
    public final Time totalTimeSpent() {
        return this.totalTimeSpent;
    }

    public final long totalTimeSpentInMillis() {
        return this.totalTimeSpentInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total_download_size");
        this.totalDownloadSize.serialize(generator, mapper);
        if (this.totalTimeSpent != null) {
            generator.writeKey("total_time_spent");
            this.totalTimeSpent.serialize(generator, mapper);
        }
        generator.writeKey("total_time_spent_in_millis");
        generator.write(this.totalTimeSpentInMillis);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRemoteStoreDownloadStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::totalDownloadSize, RemoteStoreUploadDownloadStats._DESERIALIZER, "total_download_size");
        op.add(Builder::totalTimeSpent, Time._DESERIALIZER, "total_time_spent");
        op.add(Builder::totalTimeSpentInMillis, JsonpDeserializer.longDeserializer(), "total_time_spent_in_millis");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.totalDownloadSize.hashCode();
        result = 31 * result + Objects.hashCode(this.totalTimeSpent);
        result = 31 * result + Long.hashCode(this.totalTimeSpentInMillis);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteStoreDownloadStats other = (RemoteStoreDownloadStats)o;
        return this.totalDownloadSize.equals(other.totalDownloadSize) && Objects.equals(this.totalTimeSpent, other.totalTimeSpent) && this.totalTimeSpentInMillis == other.totalTimeSpentInMillis;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RemoteStoreDownloadStats> {
        private RemoteStoreUploadDownloadStats totalDownloadSize;
        @Nullable
        private Time totalTimeSpent;
        private Long totalTimeSpentInMillis;

        public Builder() {
        }

        private Builder(RemoteStoreDownloadStats o) {
            this.totalDownloadSize = o.totalDownloadSize;
            this.totalTimeSpent = o.totalTimeSpent;
            this.totalTimeSpentInMillis = o.totalTimeSpentInMillis;
        }

        private Builder(Builder o) {
            this.totalDownloadSize = o.totalDownloadSize;
            this.totalTimeSpent = o.totalTimeSpent;
            this.totalTimeSpentInMillis = o.totalTimeSpentInMillis;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder totalDownloadSize(RemoteStoreUploadDownloadStats value) {
            this.totalDownloadSize = value;
            return this;
        }

        @Nonnull
        public final Builder totalDownloadSize(Function<RemoteStoreUploadDownloadStats.Builder, ObjectBuilder<RemoteStoreUploadDownloadStats>> fn) {
            return this.totalDownloadSize(fn.apply(new RemoteStoreUploadDownloadStats.Builder()).build());
        }

        @Nonnull
        public final Builder totalTimeSpent(@Nullable Time value) {
            this.totalTimeSpent = value;
            return this;
        }

        @Nonnull
        public final Builder totalTimeSpent(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.totalTimeSpent(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder totalTimeSpentInMillis(long value) {
            this.totalTimeSpentInMillis = value;
            return this;
        }

        @Override
        @Nonnull
        public RemoteStoreDownloadStats build() {
            this._checkSingleUse();
            return new RemoteStoreDownloadStats(this);
        }
    }
}

