/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.transport;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.neuralsearch.common.MinClusterVersionUtil;
import org.opensearch.neuralsearch.stats.events.EventStatName;
import org.opensearch.neuralsearch.stats.events.TimestampedEventStatSnapshot;
import org.opensearch.neuralsearch.stats.metrics.MemoryStatSnapshot;
import org.opensearch.neuralsearch.stats.metrics.MetricStatName;

public class NeuralStatsNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    private final Map<EventStatName, TimestampedEventStatSnapshot> eventStats;
    private final Map<MetricStatName, MemoryStatSnapshot> metricStats;

    public NeuralStatsNodeResponse(StreamInput in) throws IOException {
        super(in);
        this.eventStats = in.readMap(input -> (EventStatName)input.readEnum(EventStatName.class), TimestampedEventStatSnapshot::new);
        this.metricStats = MinClusterVersionUtil.isClusterOnOrAfterMinReqVersionForMetricStats() ? in.readMap(input -> (MetricStatName)input.readEnum(MetricStatName.class), MemoryStatSnapshot::new) : Map.of();
    }

    public NeuralStatsNodeResponse(DiscoveryNode node, Map<EventStatName, TimestampedEventStatSnapshot> eventStats, Map<MetricStatName, MemoryStatSnapshot> metricStats) {
        super(node);
        this.eventStats = eventStats;
        this.metricStats = metricStats;
    }

    public static NeuralStatsNodeResponse readStats(StreamInput in) throws IOException {
        NeuralStatsNodeResponse neuralStats = new NeuralStatsNodeResponse(in);
        return neuralStats;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.eventStats, StreamOutput::writeEnum, (output, eventStatData) -> eventStatData.writeTo(output));
        if (MinClusterVersionUtil.isClusterOnOrAfterMinReqVersionForMetricStats()) {
            out.writeMap(this.metricStats, StreamOutput::writeEnum, (output, metricStatData) -> metricStatData.writeTo(output));
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Enum stat;
        for (Map.Entry<EventStatName, TimestampedEventStatSnapshot> entry : this.eventStats.entrySet()) {
            stat = entry.getKey();
            builder.field(((EventStatName)stat).getFullPath(), entry.getValue().getValue());
        }
        for (Map.Entry<Enum, Writeable> entry : this.metricStats.entrySet()) {
            stat = (MetricStatName)entry.getKey();
            builder.field(((MetricStatName)stat).getFullPath(), ((MemoryStatSnapshot)entry.getValue()).getValue());
        }
        return builder;
    }

    @Generated
    public Map<EventStatName, TimestampedEventStatSnapshot> getEventStats() {
        return this.eventStats;
    }

    @Generated
    public Map<MetricStatName, MemoryStatSnapshot> getMetricStats() {
        return this.metricStats;
    }
}

