/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ExportTaskS3Location;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportImageTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportImageTask> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ExportImageTask.getter(ExportImageTask::description)).setter(ExportImageTask.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> EXPORT_IMAGE_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportImageTaskId").getter(ExportImageTask.getter(ExportImageTask::exportImageTaskId)).setter(ExportImageTask.setter(Builder::exportImageTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportImageTaskId").unmarshallLocationName("exportImageTaskId").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(ExportImageTask.getter(ExportImageTask::imageId)).setter(ExportImageTask.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<String> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Progress").getter(ExportImageTask.getter(ExportImageTask::progress)).setter(ExportImageTask.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").unmarshallLocationName("progress").build()}).build();
    private static final SdkField<ExportTaskS3Location> S3_EXPORT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3ExportLocation").getter(ExportImageTask.getter(ExportImageTask::s3ExportLocation)).setter(ExportImageTask.setter(Builder::s3ExportLocation)).constructor(ExportTaskS3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ExportLocation").unmarshallLocationName("s3ExportLocation").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ExportImageTask.getter(ExportImageTask::status)).setter(ExportImageTask.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ExportImageTask.getter(ExportImageTask::statusMessage)).setter(ExportImageTask.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ExportImageTask.getter(ExportImageTask::tags)).setter(ExportImageTask.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, EXPORT_IMAGE_TASK_ID_FIELD, IMAGE_ID_FIELD, PROGRESS_FIELD, S3_EXPORT_LOCATION_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportImageTask.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String exportImageTaskId;
    private final String imageId;
    private final String progress;
    private final ExportTaskS3Location s3ExportLocation;
    private final String status;
    private final String statusMessage;
    private final List<Tag> tags;

    private ExportImageTask(BuilderImpl builder) {
        this.description = builder.description;
        this.exportImageTaskId = builder.exportImageTaskId;
        this.imageId = builder.imageId;
        this.progress = builder.progress;
        this.s3ExportLocation = builder.s3ExportLocation;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
    }

    public final String description() {
        return this.description;
    }

    public final String exportImageTaskId() {
        return this.exportImageTaskId;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String progress() {
        return this.progress;
    }

    public final ExportTaskS3Location s3ExportLocation() {
        return this.s3ExportLocation;
    }

    public final String status() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportImageTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ExportLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportImageTask)) {
            return false;
        }
        ExportImageTask other = (ExportImageTask)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.exportImageTaskId(), other.exportImageTaskId()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.s3ExportLocation(), other.s3ExportLocation()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusMessage(), other.statusMessage()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ExportImageTask").add("Description", (Object)this.description()).add("ExportImageTaskId", (Object)this.exportImageTaskId()).add("ImageId", (Object)this.imageId()).add("Progress", (Object)this.progress()).add("S3ExportLocation", (Object)this.s3ExportLocation()).add("Status", (Object)this.status()).add("StatusMessage", (Object)this.statusMessage()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ExportImageTaskId": {
                return Optional.ofNullable(clazz.cast(this.exportImageTaskId()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "S3ExportLocation": {
                return Optional.ofNullable(clazz.cast(this.s3ExportLocation()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ExportImageTaskId", EXPORT_IMAGE_TASK_ID_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("Progress", PROGRESS_FIELD);
        map.put("S3ExportLocation", S3_EXPORT_LOCATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportImageTask, T> g) {
        return obj -> g.apply((ExportImageTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String exportImageTaskId;
        private String imageId;
        private String progress;
        private ExportTaskS3Location s3ExportLocation;
        private String status;
        private String statusMessage;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportImageTask model) {
            this.description(model.description);
            this.exportImageTaskId(model.exportImageTaskId);
            this.imageId(model.imageId);
            this.progress(model.progress);
            this.s3ExportLocation(model.s3ExportLocation);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.tags(model.tags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExportImageTaskId() {
            return this.exportImageTaskId;
        }

        public final void setExportImageTaskId(String exportImageTaskId) {
            this.exportImageTaskId = exportImageTaskId;
        }

        @Override
        public final Builder exportImageTaskId(String exportImageTaskId) {
            this.exportImageTaskId = exportImageTaskId;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getProgress() {
            return this.progress;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final ExportTaskS3Location.Builder getS3ExportLocation() {
            return this.s3ExportLocation != null ? this.s3ExportLocation.toBuilder() : null;
        }

        public final void setS3ExportLocation(ExportTaskS3Location.BuilderImpl s3ExportLocation) {
            this.s3ExportLocation = s3ExportLocation != null ? s3ExportLocation.build() : null;
        }

        @Override
        public final Builder s3ExportLocation(ExportTaskS3Location s3ExportLocation) {
            this.s3ExportLocation = s3ExportLocation;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ExportImageTask build() {
            return new ExportImageTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportImageTask> {
        public Builder description(String var1);

        public Builder exportImageTaskId(String var1);

        public Builder imageId(String var1);

        public Builder progress(String var1);

        public Builder s3ExportLocation(ExportTaskS3Location var1);

        default public Builder s3ExportLocation(Consumer<ExportTaskS3Location.Builder> s3ExportLocation) {
            return this.s3ExportLocation((ExportTaskS3Location)((ExportTaskS3Location.Builder)ExportTaskS3Location.builder().applyMutation(s3ExportLocation)).build());
        }

        public Builder status(String var1);

        public Builder statusMessage(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

