"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CircularButton = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const ProgressRing_1 = require("./ProgressRing");
class CircularButton extends react_1.default.PureComponent {
    constructor(props) {
        super(props);
        this.buttonRef = props.buttonRef || undefined;
    }
    render() {
        const _a = this.props, { showPercent, percent, children, className: additionalClasses, buttonRef } = _a, props = __rest(_a, ["showPercent", "percent", "children", "className", "buttonRef"]);
        const classes = classnames_1.default("circular-button", { progress: showPercent }, additionalClasses);
        return (react_1.default.createElement("button", Object.assign({ ref: this.buttonRef, className: classes }, props),
            react_1.default.createElement(ProgressRing_1.ProgressRing, { radius: 16, stroke: 1, progress: percent || 0 }),
            children));
    }
}
exports.CircularButton = CircularButton;
//# sourceMappingURL=CircularButton.js.map