/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.tuple;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.ResizeFactor;
import com.yahoo.sketches.hash.MurmurHash3;
import com.yahoo.sketches.tuple.ArrayOfDoublesCompactSketch;
import com.yahoo.sketches.tuple.ArrayOfDoublesSketch;
import com.yahoo.sketches.tuple.DirectArrayOfDoublesCompactSketch;
import com.yahoo.sketches.tuple.DirectArrayOfDoublesQuickSelectSketch;
import com.yahoo.sketches.tuple.HeapArrayOfDoublesCompactSketch;
import com.yahoo.sketches.tuple.HeapArrayOfDoublesQuickSelectSketch;
import com.yahoo.sketches.tuple.Util;

public abstract class ArrayOfDoublesUpdatableSketch
extends ArrayOfDoublesSketch {
    final long seed_;

    ArrayOfDoublesUpdatableSketch(int numValues, long seed) {
        super(numValues);
        this.seed_ = seed;
    }

    public static ArrayOfDoublesUpdatableSketch heapify(Memory mem) {
        return ArrayOfDoublesUpdatableSketch.heapify(mem, 9001L);
    }

    public static ArrayOfDoublesUpdatableSketch heapify(Memory mem, long seed) {
        return new HeapArrayOfDoublesQuickSelectSketch(mem, seed);
    }

    public static ArrayOfDoublesUpdatableSketch wrap(WritableMemory mem) {
        return ArrayOfDoublesUpdatableSketch.wrap(mem, 9001L);
    }

    public static ArrayOfDoublesUpdatableSketch wrap(WritableMemory mem, long seed) {
        return new DirectArrayOfDoublesQuickSelectSketch(mem, seed);
    }

    public void update(long key, double[] values) {
        this.update(new long[]{key}, values);
    }

    public void update(double key, double[] values) {
        this.update(Util.doubleToLongArray(key), values);
    }

    public void update(String key, double[] values) {
        this.update(Util.stringToByteArray(key), values);
    }

    public void update(byte[] key, double[] values) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, this.seed_)[0] >>> 1, values);
    }

    public void update(int[] key, double[] values) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, this.seed_)[0] >>> 1, values);
    }

    public void update(long[] key, double[] values) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, this.seed_)[0] >>> 1, values);
    }

    public abstract int getNominalEntries();

    public abstract ResizeFactor getResizeFactor();

    public abstract float getSamplingProbability();

    public abstract void trim();

    public abstract void reset();

    public ArrayOfDoublesCompactSketch compact() {
        return this.compact(null);
    }

    public ArrayOfDoublesCompactSketch compact(WritableMemory dstMem) {
        if (dstMem == null) {
            return new HeapArrayOfDoublesCompactSketch(this);
        }
        return new DirectArrayOfDoublesCompactSketch(this, dstMem);
    }

    abstract int getCurrentCapacity();

    long getSeed() {
        return this.seed_;
    }

    @Override
    short getSeedHash() {
        return Util.computeSeedHash(this.seed_);
    }

    abstract void insertOrIgnore(long var1, double[] var3);
}

