/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import java.util.function.BiPredicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.cluster.routing.allocation.decider.AllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

public class NodeLoadAwareAllocationDecider
extends AllocationDecider {
    public static final String NAME = "load_awareness";
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_PROVISIONED_CAPACITY_SETTING = Setting.intSetting("cluster.routing.allocation.load_awareness.provisioned_capacity", -1, -1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_SKEW_FACTOR_SETTING = Setting.doubleSetting("cluster.routing.allocation.load_awareness.skew_factor", 50.0, -1.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_ALLOW_UNASSIGNED_PRIMARIES_SETTING = Setting.boolSetting("cluster.routing.allocation.load_awareness.allow_unassigned_primaries", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_FLAT_SKEW_SETTING = Setting.intSetting("cluster.routing.allocation.load_awareness.flat_skew", 2, 2, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile int provisionedCapacity;
    private volatile double skewFactor;
    private volatile boolean allowUnassignedPrimaries;
    private volatile int flatSkew;
    private static final Logger logger = LogManager.getLogger(NodeLoadAwareAllocationDecider.class);

    public NodeLoadAwareAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.skewFactor = CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_SKEW_FACTOR_SETTING.get(settings);
        this.provisionedCapacity = CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_PROVISIONED_CAPACITY_SETTING.get(settings);
        this.allowUnassignedPrimaries = CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_ALLOW_UNASSIGNED_PRIMARIES_SETTING.get(settings);
        this.flatSkew = CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_FLAT_SKEW_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_SKEW_FACTOR_SETTING, this::setSkewFactor);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_PROVISIONED_CAPACITY_SETTING, this::setProvisionedCapacity);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_ALLOW_UNASSIGNED_PRIMARIES_SETTING, this::setAllowUnassignedPrimaries);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_FLAT_SKEW_SETTING, this::setFlatSkew);
    }

    private void setAllowUnassignedPrimaries(boolean allowUnassignedPrimaries) {
        this.allowUnassignedPrimaries = allowUnassignedPrimaries;
    }

    private void setSkewFactor(double skewFactor) {
        this.skewFactor = skewFactor;
    }

    private void setProvisionedCapacity(int provisionedCapacity) {
        this.provisionedCapacity = provisionedCapacity;
    }

    private void setFlatSkew(int flatSkew) {
        this.flatSkew = flatSkew;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.underCapacity(shardRouting, node, allocation, (count, limit) -> count >= limit);
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.underCapacity(shardRouting, node, allocation, (count, limit) -> count > limit);
    }

    private Decision underCapacity(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation, BiPredicate<Integer, Integer> decider) {
        if (this.provisionedCapacity <= 0 || this.skewFactor < 0.0) {
            return allocation.decision(Decision.YES, NAME, "overload awareness allocation is not enabled, set cluster setting [%s] and cluster setting [%s] to enable it", CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_SKEW_FACTOR_SETTING.getKey(), CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_PROVISIONED_CAPACITY_SETTING.getKey());
        }
        if (shardRouting.unassigned() && shardRouting.primary() && this.allowUnassignedPrimaries) {
            return allocation.decision(Decision.YES, NAME, "overload allocation awareness is allowed for unassigned primaries, set cluster setting [%s] to disable it", CLUSTER_ROUTING_ALLOCATION_LOAD_AWARENESS_ALLOW_UNASSIGNED_PRIMARIES_SETTING.getKey());
        }
        Metadata metadata = allocation.metadata();
        float expectedAvgShardsPerNode = (float)metadata.getTotalNumberOfShards() / (float)this.provisionedCapacity;
        int nodeShardCount = node.numberOfOwningShards();
        int limit = this.flatSkew + (int)Math.ceil((double)expectedAvgShardsPerNode * (1.0 + this.skewFactor / 100.0));
        if (decider.test(nodeShardCount, limit)) {
            logger.debug(() -> new ParameterizedMessage("Too many shards [{}] allocated to this node [{}]. Expected average shards per node [{}], overload factor [{}], node limit [{}]", new Object[]{nodeShardCount, node.nodeId(), Float.valueOf(expectedAvgShardsPerNode), this.skewFactor, limit}));
            return allocation.decision(Decision.NO, NAME, "too many shards [%d] allocated to this node, limit per node [%d] considering overload factor [%.2f] and flat skew [%d] based on capacity [%d]", nodeShardCount, limit, this.skewFactor, this.flatSkew, this.provisionedCapacity);
        }
        return allocation.decision(Decision.YES, NAME, "node meets all skew awareness attribute requirements", new Object[0]);
    }
}

