/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.sql.Connection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.xa.OracleXAResource;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroResource;

public class OracleXAHeteroConnection
extends OracleXAConnection {
    private int rmid = -1;
    private String xaCloseString = null;

    public OracleXAHeteroConnection() throws XAException {
    }

    public OracleXAHeteroConnection(Connection pc) throws XAException {
        super(pc);
    }

    @Override
    public XAResource getXAResource() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try {
                if (this.xaResource == null) {
                    this.xaResource = new OracleXAHeteroResource((Connection)this.physicalConn, this);
                    ((OracleXAHeteroResource)this.xaResource).setRmid(this.rmid);
                    if (this.logicalHandle != null) {
                        ((OracleXAResource)this.xaResource).setLogicalConnection(this.logicalHandle);
                    }
                }
            }
            catch (XAException xae) {
                this.xaResource = null;
            }
            XAResource xAResource = this.xaResource;
            return xAResource;
        }
    }

    void setRmid(int rmid) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.rmid = rmid;
        }
    }

    int getRmid() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int n = this.rmid;
            return n;
        }
    }

    void setXaCloseString(String xaCloseString) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.xaCloseString = xaCloseString;
        }
    }

    String getXaCloseString() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String string = this.xaCloseString;
            return string;
        }
    }
}

