# -*- coding: binary -*-
require 'rex/exploitation/ropdb'

##
#
# This mixin provides an interface to selecting a ROP chain, or creating a payload with
# ROP using the Rex::Exploitation::RopDb class.
#
##

module Msf
module Exploit::RopDb

  def initialize(info = {})
    @rop_db = Rex::Exploitation::RopDb.new
    super
  end

  def has_rop?(rop)
    @rop_db.has_rop?(rop)
  end

  def select_rop(rop, opts={})
    rop = @rop_db.select_rop(rop, opts)
    return rop
  end

  def generate_rop_payload(rop, payload, opts={})
    opts['badchars'] ||= payload_badchars
    rop_payload = @rop_db.generate_rop_payload(rop, payload, opts)
    return rop_payload
  end

  def rop_junk
    rand_text_alpha(4).unpack("V")[0].to_i
  end

  def rop_nop
    make_nops(4).unpack("V")[0].to_i
  end

end
end