/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier.internal.asn1;

import com.webauthn4j.util.UnsignedNumberUtil;
import com.webauthn4j.verifier.internal.asn1.ASN1;
import com.webauthn4j.verifier.internal.asn1.ASN1Length;
import com.webauthn4j.verifier.internal.asn1.ASN1Structure;
import com.webauthn4j.verifier.internal.asn1.ASN1Tag;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class ASN1Primitive
extends ASN1 {
    private final byte[] value;

    public static ASN1Primitive parse(byte[] bytes) {
        return ASN1Primitive.parse(ByteBuffer.wrap(bytes));
    }

    public static ASN1Primitive parse(ByteBuffer byteBuffer) {
        ASN1Tag tag = ASN1Tag.parse(byteBuffer);
        ASN1Length length = ASN1Length.parse(byteBuffer);
        if (tag.isConstructed()) {
            throw new IllegalArgumentException("non primitive data is provided");
        }
        byte[] value = ASN1Primitive.parseValue(byteBuffer, length);
        return new ASN1Primitive(tag, length, value);
    }

    public static byte[] parseValue(ByteBuffer byteBuffer, ASN1Length length) {
        byte[] buffer = new byte[length.getValueLength()];
        byteBuffer.get(buffer);
        return buffer;
    }

    ASN1Primitive(ASN1Tag tag, ASN1Length length, byte[] value) {
        super(tag, length);
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String getValueAsUtf8String() {
        return new String(this.value, StandardCharsets.UTF_8);
    }

    public byte[] getValueAsBitString() {
        if (this.value.length == 0) {
            return new byte[0];
        }
        short unusedBits = UnsignedNumberUtil.getUnsignedByte(this.value[0]);
        byte[] cloned = Arrays.copyOfRange(this.value, 1, this.value.length);
        cloned[cloned.length - 1] = (byte)(cloned[cloned.length - 1] >> unusedBits << unusedBits);
        return cloned;
    }

    public BigInteger getValueAsBigInteger() {
        return new BigInteger(this.value);
    }

    public ASN1Primitive getValueAsASN1Primitive() {
        return ASN1Primitive.parse(this.getValue());
    }

    public ASN1Structure getValueAsASN1Structure() {
        return ASN1Structure.parse(this.getValue());
    }
}

