/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.vertx.ext.web.RoutingContext;

public class BytesSentAttribute
implements ExchangeAttribute {
    public static final String BYTES_SENT_SHORT_UPPER = "%B";
    public static final String BYTES_SENT_SHORT_LOWER = "%b";
    public static final String BYTES_SENT = "%{BYTES_SENT}";
    private final boolean dashIfZero;

    public BytesSentAttribute(boolean dashIfZero) {
        this.dashIfZero = dashIfZero;
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        if (this.dashIfZero) {
            long bytesSent = exchange.response().bytesWritten();
            return bytesSent == 0L ? "-" : Long.toString(bytesSent);
        }
        return Long.toString(exchange.response().bytesWritten());
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Bytes sent", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Bytes Sent";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(BytesSentAttribute.BYTES_SENT_SHORT_LOWER)) {
                return new BytesSentAttribute(true);
            }
            if (token.equals(BytesSentAttribute.BYTES_SENT) || token.equals(BytesSentAttribute.BYTES_SENT_SHORT_UPPER)) {
                return new BytesSentAttribute(false);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

