/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.function.Supplier;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.container.impl.BoundedSegmentedDataContainer;
import org.infinispan.container.impl.DefaultDataContainer;
import org.infinispan.container.impl.DefaultSegmentedDataContainer;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.L1SegmentedDataContainer;
import org.infinispan.container.impl.PeekableTouchableContainerMap;
import org.infinispan.container.offheap.BoundedOffHeapDataContainer;
import org.infinispan.container.offheap.OffHeapConcurrentMap;
import org.infinispan.container.offheap.OffHeapDataContainer;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.SegmentedBoundedOffHeapDataContainer;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;

@DefaultFactoryFor(classes={InternalDataContainer.class})
public class DataContainerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public Object construct(String componentName) {
        InternalDataContainer dataContainer;
        long thresholdSize;
        ClusteringConfiguration clusteringConfiguration = this.configuration.clustering();
        boolean shouldSegment = clusteringConfiguration.cacheMode().needsStateTransfer();
        int level = this.configuration.locking().concurrencyLevel();
        MemoryConfiguration memoryConfiguration = this.configuration.memory();
        boolean offHeap = memoryConfiguration.isOffHeap();
        EvictionStrategy strategy = memoryConfiguration.whenFull();
        if (strategy.isExceptionBased() || !strategy.isEnabled()) {
            if (offHeap) {
                if (shouldSegment) {
                    int segments = clusteringConfiguration.hash().numSegments();
                    Supplier mapSupplier = this::createAndStartOffHeapConcurrentMap;
                    if (clusteringConfiguration.l1().enabled()) {
                        return new L1SegmentedDataContainer(mapSupplier, segments);
                    }
                    return new DefaultSegmentedDataContainer(mapSupplier, segments);
                }
                return new OffHeapDataContainer();
            }
            if (shouldSegment) {
                Supplier mapSupplier = PeekableTouchableContainerMap::new;
                int segments = clusteringConfiguration.hash().numSegments();
                if (clusteringConfiguration.l1().enabled()) {
                    return new L1SegmentedDataContainer(mapSupplier, segments);
                }
                return new DefaultSegmentedDataContainer(mapSupplier, segments);
            }
            return DefaultDataContainer.unBoundedDataContainer(level);
        }
        boolean sizeInBytes = memoryConfiguration.maxSize() != null;
        long l = thresholdSize = sizeInBytes ? memoryConfiguration.maxSizeBytes() : memoryConfiguration.maxCount();
        if (offHeap) {
            if (shouldSegment) {
                int segments = clusteringConfiguration.hash().numSegments();
                dataContainer = new SegmentedBoundedOffHeapDataContainer(segments, thresholdSize, memoryConfiguration.evictionType());
            } else {
                dataContainer = new BoundedOffHeapDataContainer(thresholdSize, memoryConfiguration.evictionType());
            }
        } else if (shouldSegment) {
            int segments = clusteringConfiguration.hash().numSegments();
            dataContainer = new BoundedSegmentedDataContainer(segments, thresholdSize, memoryConfiguration.evictionType());
        } else {
            dataContainer = DefaultDataContainer.boundedDataContainer(level, thresholdSize, memoryConfiguration.evictionType());
        }
        if (sizeInBytes) {
            memoryConfiguration.attributes().attribute(MemoryConfiguration.MAX_SIZE).addListener((newSize, old) -> dataContainer.resize(memoryConfiguration.maxSizeBytes()));
        } else {
            memoryConfiguration.attributes().attribute(MemoryConfiguration.MAX_COUNT).addListener((newSize, old) -> dataContainer.resize((Long)newSize.get()));
        }
        return dataContainer;
    }

    OffHeapConcurrentMap createAndStartOffHeapConcurrentMap() {
        OffHeapEntryFactory entryFactory = this.componentRegistry.getOrCreateComponent(OffHeapEntryFactory.class);
        OffHeapMemoryAllocator memoryAllocator = this.componentRegistry.getOrCreateComponent(OffHeapMemoryAllocator.class);
        return new OffHeapConcurrentMap(memoryAllocator, entryFactory, null);
    }
}

