/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.tree.domain.NonAggregatedCompositeSimplePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.from.TableGroup;

public class NonAggregatedCompositeValuedPathInterpretation<T>
extends AbstractSqmPathInterpretation<T>
implements SqlTupleContainer {
    private final SqlTuple sqlExpression;
    private final @Nullable String affectedTableName;

    public static <T> NonAggregatedCompositeValuedPathInterpretation<T> from(NonAggregatedCompositeSimplePath<T> sqmPath, SqmToSqlAstConverter converter, SqmToSqlAstConverter sqlAstCreationState) {
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().findTableGroup(sqmPath.getLhs().getNavigablePath());
        NonAggregatedIdentifierMapping mapping = (NonAggregatedIdentifierMapping)tableGroup.getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null);
        return new NonAggregatedCompositeValuedPathInterpretation<T>(mapping.toSqlExpression(tableGroup, converter.getCurrentClauseStack().getCurrent(), converter, converter), sqmPath.getNavigablePath(), mapping, tableGroup, SqmUtil.determineAffectedTableName(tableGroup, mapping));
    }

    private NonAggregatedCompositeValuedPathInterpretation(SqlTuple sqlExpression, NavigablePath navigablePath, NonAggregatedIdentifierMapping mapping, TableGroup tableGroup, @Nullable String affectedTableName) {
        super(navigablePath, mapping, tableGroup);
        this.sqlExpression = sqlExpression;
        this.affectedTableName = affectedTableName;
    }

    @Override
    public SqlTuple getSqlExpression() {
        return this.sqlExpression;
    }

    @Override
    public @Nullable String getAffectedTableName() {
        return this.affectedTableName;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.sqlExpression.accept(sqlTreeWalker);
    }

    @Override
    public SqlTuple getSqlTuple() {
        return this.sqlExpression;
    }
}

