/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.registry.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Internal;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.service.Service;
import org.hibernate.service.internal.AbstractServiceRegistryImpl;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceInitiator;

public class StandardServiceRegistryImpl
extends AbstractServiceRegistryImpl
implements StandardServiceRegistry {
    private Map<String, Object> configurationValues;

    protected StandardServiceRegistryImpl(boolean autoCloseRegistry, BootstrapServiceRegistry bootstrapServiceRegistry, Map<String, Object> configurationValues) {
        super(bootstrapServiceRegistry, autoCloseRegistry);
        this.configurationValues = StandardServiceRegistryImpl.normalize(configurationValues);
    }

    public static StandardServiceRegistryImpl create(BootstrapServiceRegistry bootstrapServiceRegistry, List<StandardServiceInitiator<?>> serviceInitiators, List<ProvidedService<?>> providedServices, Map<String, Object> configurationValues) {
        return StandardServiceRegistryImpl.create(true, bootstrapServiceRegistry, serviceInitiators, providedServices, configurationValues);
    }

    public static StandardServiceRegistryImpl create(boolean autoCloseRegistry, BootstrapServiceRegistry bootstrapServiceRegistry, List<StandardServiceInitiator<?>> serviceInitiators, List<ProvidedService<?>> providedServices, Map<String, Object> configurationValues) {
        StandardServiceRegistryImpl instance = new StandardServiceRegistryImpl(autoCloseRegistry, bootstrapServiceRegistry, configurationValues);
        instance.initialize();
        instance.applyServiceRegistrations(serviceInitiators, providedServices);
        return instance;
    }

    protected void applyServiceRegistrations(List<StandardServiceInitiator<?>> serviceInitiators, List<ProvidedService<?>> providedServices) {
        try {
            for (ServiceInitiator serviceInitiator : serviceInitiators) {
                this.createServiceBinding(serviceInitiator);
            }
            for (ProvidedService providedService : providedServices) {
                this.createServiceBinding(providedService);
            }
        }
        catch (RuntimeException e) {
            this.visitServiceBindings(binding -> binding.getLifecycleOwner().stopService(binding));
            throw e;
        }
    }

    @Internal
    public synchronized void resetAndReactivate(BootstrapServiceRegistry bootstrapServiceRegistry, List<StandardServiceInitiator<?>> serviceInitiators, List<ProvidedService<?>> providedServices, Map<?, ?> configurationValues) {
        if (super.isActive()) {
            throw new IllegalStateException("Can't reactivate an active registry");
        }
        super.resetParent(bootstrapServiceRegistry);
        this.configurationValues = new HashMap(configurationValues);
        super.reactivate();
        this.applyServiceRegistrations(serviceInitiators, providedServices);
    }

    @Override
    public synchronized <R extends Service> R initiateService(ServiceInitiator<R> serviceInitiator) {
        return ((StandardServiceInitiator)serviceInitiator).initiateService(this.configurationValues, this);
    }

    @Override
    public synchronized <R extends Service> void configureService(ServiceBinding<R> serviceBinding) {
        R r = serviceBinding.getService();
        if (r instanceof Configurable) {
            Configurable configurable = (Configurable)r;
            configurable.configure(this.configurationValues);
        }
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        this.configurationValues = null;
    }

    private static Map<String, Object> normalize(Map<String, Object> configurationValues) {
        Object jtaDatasource;
        Object nonJtaDatasource;
        Object driver;
        Object password;
        Object username;
        Object jdbcUrl = configurationValues.get("jakarta.persistence.jdbc.url");
        if (jdbcUrl != null) {
            configurationValues.putIfAbsent("hibernate.connection.url", jdbcUrl);
        }
        if ((username = configurationValues.get("jakarta.persistence.jdbc.user")) != null) {
            configurationValues.putIfAbsent("hibernate.connection.username", username);
        }
        if ((password = configurationValues.get("jakarta.persistence.jdbc.password")) != null) {
            configurationValues.putIfAbsent("hibernate.connection.password", password);
        }
        if ((driver = configurationValues.get("jakarta.persistence.jdbc.driver")) != null) {
            configurationValues.putIfAbsent("hibernate.connection.driver_class", driver);
        }
        if ((nonJtaDatasource = configurationValues.get("jakarta.persistence.nonJtaDataSource")) != null) {
            configurationValues.putIfAbsent("hibernate.connection.datasource", nonJtaDatasource);
        }
        if ((jtaDatasource = configurationValues.get("jakarta.persistence.jtaDataSource")) != null) {
            configurationValues.putIfAbsent("hibernate.connection.datasource", jtaDatasource);
        }
        return configurationValues;
    }
}

