/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import java.io.IOException;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resource.AccountResourceProvider;
import org.keycloak.services.resource.AccountResourceProviderFactory;
import org.keycloak.services.resources.account.AccountConsole;
import org.keycloak.theme.Theme;

public class AccountConsoleFactory
implements AccountResourceProviderFactory {
    public String getId() {
        return "default";
    }

    public AccountResourceProvider create(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        ClientModel client = this.getAccountManagementClient(realm);
        Theme theme = this.getTheme(session);
        return this.createAccountConsole(session, client, theme);
    }

    protected AccountConsole createAccountConsole(KeycloakSession session, ClientModel client, Theme theme) {
        return new AccountConsole(session, client, theme);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    protected Theme getTheme(KeycloakSession session) {
        try {
            return session.theme().getTheme(Theme.Type.ACCOUNT);
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    protected ClientModel getAccountManagementClient(RealmModel realm) {
        ClientModel client = realm.getClientByClientId("account");
        if (client == null || !client.isEnabled()) {
            throw new NotFoundException("account management not enabled");
        }
        return client;
    }
}

