/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.jboss.logging.Logger;
import org.keycloak.Token;
import org.keycloak.TokenCategory;
import org.keycloak.cookie.CookieProvider;
import org.keycloak.cookie.CookieType;
import org.keycloak.crypto.KeyUse;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.TokenUtil;

public class RestartLoginCookie
implements Token {
    private static final Logger logger = Logger.getLogger(RestartLoginCookie.class);
    public static final String KC_RESTART = "KC_RESTART";
    @JsonProperty(value="cid")
    protected String clientId;
    @JsonProperty(value="pty")
    protected String authMethod;
    @JsonProperty(value="ruri")
    protected String redirectUri;
    @JsonProperty(value="act")
    protected String action;
    @JsonProperty(value="notes")
    protected Map<String, String> notes = new HashMap<String, String>();
    @Deprecated
    @JsonProperty(value="cs")
    protected String cs;

    public Map<String, String> getNotes() {
        return this.notes;
    }

    public void setNotes(Map<String, String> notes) {
        this.notes = notes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public RestartLoginCookie() {
    }

    public RestartLoginCookie(AuthenticationSessionModel authSession) {
        this.action = authSession.getAction();
        this.clientId = authSession.getClient().getClientId();
        this.authMethod = authSession.getProtocol();
        this.redirectUri = authSession.getRedirectUri();
        for (Map.Entry entry : authSession.getClientNotes().entrySet()) {
            this.notes.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static void setRestartCookie(KeycloakSession session, AuthenticationSessionModel authSession) {
        RestartLoginCookie restart = new RestartLoginCookie(authSession);
        String encoded = RestartLoginCookie.encodeAndEncrypt(session, restart);
        ((CookieProvider)session.getProvider(CookieProvider.class)).set(CookieType.AUTH_RESTART, encoded);
    }

    public static void expireRestartCookie(KeycloakSession session) {
        ((CookieProvider)session.getProvider(CookieProvider.class)).expire(CookieType.AUTH_RESTART);
    }

    public static String getRestartCookie(KeycloakSession session) {
        String cook = ((CookieProvider)session.getProvider(CookieProvider.class)).get(CookieType.AUTH_RESTART);
        if (cook == null) {
            logger.debug((Object)"KC_RESTART cookie doesn't exist");
            return null;
        }
        return cook;
    }

    public static AuthenticationSessionModel restartSession(KeycloakSession session, RealmModel realm, RootAuthenticationSessionModel rootSession, String expectedClientId, String encodedCookie) throws Exception {
        RestartLoginCookie cookie = RestartLoginCookie.decryptAndDecode(session, encodedCookie);
        if (cookie == null) {
            logger.debug((Object)"Failed to verify encoded RestartLoginCookie");
            return null;
        }
        ClientModel client = realm.getClientByClientId(cookie.getClientId());
        if (client == null) {
            return null;
        }
        if (!client.getClientId().equals(expectedClientId)) {
            logger.debugf("Skip restarting from the KC_RESTART. Clients doesn't match: Cookie client: %s, Requested client: %s", (Object)client.getClientId(), (Object)expectedClientId);
            return null;
        }
        if (rootSession == null) {
            rootSession = new AuthenticationSessionManager(session).createAuthenticationSession(realm, true);
        }
        AuthenticationSessionModel authSession = rootSession.createAuthenticationSession(client);
        authSession.setProtocol(cookie.getAuthMethod());
        authSession.setRedirectUri(cookie.getRedirectUri());
        authSession.setAction(cookie.getAction());
        for (Map.Entry<String, String> entry : cookie.getNotes().entrySet()) {
            authSession.setClientNote(entry.getKey(), entry.getValue());
        }
        return authSession;
    }

    private static RestartLoginCookie decryptAndDecode(KeycloakSession session, String encodedToken) {
        try {
            String sigAlgorithm = session.tokens().signatureAlgorithm(TokenCategory.INTERNAL);
            String algAlgorithm = session.tokens().cekManagementAlgorithm(TokenCategory.INTERNAL);
            SecretKey encKey = session.keys().getActiveKey(session.getContext().getRealm(), KeyUse.ENC, algAlgorithm).getSecretKey();
            SecretKey signKey = session.keys().getActiveKey(session.getContext().getRealm(), KeyUse.SIG, sigAlgorithm).getSecretKey();
            byte[] contentBytes = TokenUtil.jweDirectVerifyAndDecode((Key)encKey, (Key)signKey, (String)encodedToken);
            String jwt = new String(contentBytes, StandardCharsets.UTF_8);
            return (RestartLoginCookie)session.tokens().decode(jwt, RestartLoginCookie.class);
        }
        catch (Exception e) {
            return (RestartLoginCookie)session.tokens().decode(encodedToken, RestartLoginCookie.class);
        }
    }

    private static String encodeAndEncrypt(KeycloakSession session, RestartLoginCookie cookie) {
        try {
            String sigAlgorithm = session.tokens().signatureAlgorithm(cookie.getCategory());
            String algAlgorithm = session.tokens().cekManagementAlgorithm(cookie.getCategory());
            SecretKey encKey = session.keys().getActiveKey(session.getContext().getRealm(), KeyUse.ENC, algAlgorithm).getSecretKey();
            SecretKey signKey = session.keys().getActiveKey(session.getContext().getRealm(), KeyUse.SIG, sigAlgorithm).getSecretKey();
            String encodedJwt = session.tokens().encode((Token)cookie);
            return TokenUtil.jweDirectEncode((Key)encKey, (Key)signKey, (byte[])encodedJwt.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RuntimeException("Error encoding cookie.", e);
        }
    }

    public TokenCategory getCategory() {
        return TokenCategory.INTERNAL;
    }
}

