/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.builder.Json;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JniRuntimeAccessBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JniRuntimeAccessFieldBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JniRuntimeAccessMethodBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NativeImageJNIConfigStep {
    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void generateJniConfig(BuildProducer<GeneratedResourceBuildItem> jniConfig, List<JniRuntimeAccessBuildItem> jniRuntimeAccessibleClasses, List<JniRuntimeAccessFieldBuildItem> jniRuntimeAccessibleFields, List<JniRuntimeAccessMethodBuildItem> jniRuntimeAccessibleMethods) {
        LinkedHashMap jniClasses = new LinkedHashMap();
        jniRuntimeAccessibleClasses.forEach(c -> this.addJniClass(jniClasses, (JniRuntimeAccessBuildItem)((Object)c)));
        jniRuntimeAccessibleFields.forEach(f -> this.addJniField(jniClasses, (JniRuntimeAccessFieldBuildItem)((Object)f)));
        jniRuntimeAccessibleMethods.forEach(m -> this.addJniMethod(jniClasses, (JniRuntimeAccessMethodBuildItem)((Object)m)));
        Json.JsonArrayBuilder root = Json.array();
        for (Map.Entry entry : jniClasses.entrySet()) {
            int i;
            Json.JsonArrayBuilder paramsArray;
            Json.JsonObjectBuilder methodObject;
            Json.JsonObjectBuilder json = Json.object();
            json.put("name", (String)entry.getKey());
            JniInfo info = (JniInfo)entry.getValue();
            Json.JsonArrayBuilder methodsArray = Json.array();
            if (info.constructors) {
                json.put("allDeclaredConstructors", true);
            } else if (!info.ctorSet.isEmpty()) {
                for (JniRuntimeAccessMethodBuildItem ctor : info.ctorSet) {
                    methodObject = Json.object();
                    methodObject.put("name", ctor.getName());
                    paramsArray = Json.array();
                    for (i = 0; i < ctor.getParams().length; ++i) {
                        paramsArray.add(ctor.getParams()[i]);
                    }
                    methodObject.put("parameterTypes", paramsArray);
                    methodsArray.add(methodObject);
                }
            }
            if (info.methods) {
                json.put("allDeclaredMethods", true);
            } else if (!info.methodSet.isEmpty()) {
                for (JniRuntimeAccessMethodBuildItem method : info.methodSet) {
                    methodObject = Json.object();
                    methodObject.put("name", method.getName());
                    paramsArray = Json.array();
                    for (i = 0; i < method.getParams().length; ++i) {
                        paramsArray.add(method.getParams()[i]);
                    }
                    methodObject.put("parameterTypes", paramsArray);
                    methodsArray.add(methodObject);
                }
            }
            if (!methodsArray.isEmpty()) {
                json.put("methods", methodsArray);
            }
            if (info.fields) {
                json.put("allDeclaredFields", true);
            } else if (!info.fieldSet.isEmpty()) {
                Json.JsonArrayBuilder fieldsArray = Json.array();
                for (String fieldName : info.fieldSet) {
                    fieldsArray.add(Json.object().put("name", fieldName));
                }
                json.put("fields", fieldsArray);
            }
            root.add(json);
        }
        try (StringWriter writer = new StringWriter();){
            root.appendTo((Appendable)writer);
            jniConfig.produce(new GeneratedResourceBuildItem("META-INF/native-image/jni-config.json", writer.toString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addJniClass(Map<String, JniInfo> jniClasses, JniRuntimeAccessBuildItem jniRuntimeAccessBuildItem) {
        for (String cl : jniRuntimeAccessBuildItem.getClassNames()) {
            JniInfo existing = jniClasses.get(cl);
            if (existing == null) {
                jniClasses.put(cl, new JniInfo(jniRuntimeAccessBuildItem));
                continue;
            }
            if (jniRuntimeAccessBuildItem.isConstructors()) {
                existing.constructors = true;
            }
            if (jniRuntimeAccessBuildItem.isMethods()) {
                existing.methods = true;
            }
            if (!jniRuntimeAccessBuildItem.isFields()) continue;
            existing.fields = true;
        }
    }

    private void addJniMethod(Map<String, JniInfo> reflectiveClasses, JniRuntimeAccessMethodBuildItem methodInfo) {
        String cl = methodInfo.getDeclaringClass();
        JniInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new JniInfo();
            reflectiveClasses.put(cl, existing);
        }
        if (methodInfo.getName().equals("<init>")) {
            existing.ctorSet.add(methodInfo);
        } else {
            existing.methodSet.add(methodInfo);
        }
    }

    private void addJniField(Map<String, JniInfo> jniClasses, JniRuntimeAccessFieldBuildItem fieldInfo) {
        String cl = fieldInfo.getDeclaringClass();
        JniInfo existing = jniClasses.get(cl);
        if (existing == null) {
            existing = new JniInfo();
            jniClasses.put(cl, existing);
        }
        existing.fieldSet.add(fieldInfo.getName());
    }

    static final class JniInfo {
        boolean constructors;
        boolean methods;
        boolean fields;
        Set<String> fieldSet = new HashSet<String>();
        Set<JniRuntimeAccessMethodBuildItem> methodSet = new HashSet<JniRuntimeAccessMethodBuildItem>();
        Set<JniRuntimeAccessMethodBuildItem> ctorSet = new HashSet<JniRuntimeAccessMethodBuildItem>();

        private JniInfo(boolean methods, boolean fields, boolean constructors) {
            this.methods = methods;
            this.fields = fields;
            this.constructors = constructors;
        }

        private JniInfo() {
            this(false, false, false);
        }

        private JniInfo(JniRuntimeAccessBuildItem jniRuntimeAccessBuildItem) {
            this(jniRuntimeAccessBuildItem.isMethods(), jniRuntimeAccessBuildItem.isFields(), jniRuntimeAccessBuildItem.isConstructors());
        }
    }
}

