/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Function;
import org.jboss.logging.Logger;

public class OutputFilter
implements Function<InputStream, Runnable> {
    private final StringBuilder builder = new StringBuilder();
    private static final Logger log = Logger.getLogger(OutputFilter.class);

    @Override
    public Runnable apply(InputStream is) {
        return () -> {
            try (InputStreamReader isr = new InputStreamReader(is);
                 BufferedReader reader = new BufferedReader(isr);){
                String line = reader.readLine();
                while (line != null) {
                    this.builder.append(line);
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                if (e.getMessage().contains("Stream closed")) {
                    log.warn((Object)"Stream is closed, ignoring and trying to continue");
                }
                throw new RuntimeException("Error reading stream.", e);
            }
        };
    }

    public String getOutput() {
        return this.builder.toString();
    }
}

