/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JSpinner;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.shaper.ClassicButtonShaper;
import org.jvnet.substance.utils.Sideable;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.border.SubstanceButtonBorder;

public class SubstanceSpinnerButton
extends JButton
implements Sideable {
    private int orientation;

    public SubstanceSpinnerButton(JSpinner spinner, final int orientation) {
        this.setEnabled(spinner.isEnabled());
        this.setFocusable(false);
        this.setRequestFocusEnabled(false);
        this.setMargin(new Insets(0, 0, 0, 2));
        this.setBorder(new SubstanceButtonBorder(ClassicButtonShaper.class){

            @Override
            public Insets getBorderInsets(Component c) {
                int extraPadding = SubstanceSizeUtils.getExtraPadding(SubstanceSizeUtils.getComponentFontSize(c));
                int deltaTop = orientation == 1 ? 2 : 0;
                int deltaBottom = orientation == 1 ? 0 : 2;
                return new Insets(extraPadding + deltaTop, extraPadding, extraPadding + deltaBottom, extraPadding);
            }
        });
        this.orientation = orientation;
        this.putClientProperty("substancelaf.useThemedDefaultIcons", Boolean.FALSE);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public SubstanceConstants.Side getSide() {
        switch (this.orientation) {
            case 1: {
                return SubstanceConstants.Side.BOTTOM;
            }
            case 7: {
                return SubstanceConstants.Side.RIGHT;
            }
            case 5: {
                return SubstanceConstants.Side.TOP;
            }
            case 3: {
                return SubstanceConstants.Side.LEFT;
            }
        }
        return null;
    }

    static {
        FadeConfigurationManager.getInstance().disallowFades(FadeKind.GHOSTING_BUTTON_PRESS, SubstanceSpinnerButton.class);
        FadeConfigurationManager.getInstance().disallowFades(FadeKind.GHOSTING_ICON_ROLLOVER, SubstanceSpinnerButton.class);
    }
}

