/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Generates the upwind gradient field of fast marching arrival times.


This filter adds some extra functionality to its base class. While the
solution T(x) of the Eikonal equation is being generated by the base
class with the fast marching method, the filter generates the upwind
gradient vectors of T(x), storing them in an image.

Since the Eikonal equation generates the arrival times of a wave
traveling at a given speed, the generated gradient vectors can be
interpreted as the slowness (1/velocity) vectors of the front (the
quantity inside the modulus operator in the Eikonal equation).

Gradient vectors are computed using upwind finite differences, that
is, information only propagates from points where the wavefront has
already passed. This is consistent with how the fast marching method
works.

One more extra feature is the possibility to define a set of Target
points where the propagation stops. This can be used to avoid
computing the Eikonal solution for the whole domain. The front can be
stopped either when one Target point is reached or all Target points
are reached. The propagation can stop after a time TargetOffset has
passed since the stop condition is met. This way the solution is
computed a bit downstream the Target points, so that the level sets of
T(x) corresponding to the Target are smooth.

For an alternative implementation, see itk::FastMarchingUpwindGradientImageFilterBase .


Luca Antiga Ph.D. Biomedical Technologies Laboratory, Bioengineering
Department, Mario Negri Institute, Italy.

See:
 itk::simple::FastMarchingUpwindGradient for the procedural interface

 itk::FastMarchingUpwindGradientImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkFastMarchingUpwindGradientImageFilter.h
*/
public class FastMarchingUpwindGradientImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected FastMarchingUpwindGradientImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.FastMarchingUpwindGradientImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(FastMarchingUpwindGradientImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(FastMarchingUpwindGradientImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::FastMarchingUpwindGradientImageFilter::~FastMarchingUpwindGradientImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_FastMarchingUpwindGradientImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::FastMarchingUpwindGradientImageFilter::FastMarchingUpwindGradientImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  FastMarchingUpwindGradientImageFilter() {
    this(SimpleITKJNI.new_FastMarchingUpwindGradientImageFilter(), true);
  }

  /**
Self&amp; itk::simple::FastMarchingUpwindGradientImageFilter::SetTrialPoints(std::vector&lt; std::vector&lt; unsigned int &gt; &gt; TrialPoints)
*/
public  void setTrialPoints(VectorUIntList TrialPoints) {
    SimpleITKJNI.FastMarchingUpwindGradientImageFilter_setTrialPoints(swigCPtr, this, VectorUIntList.getCPtr(TrialPoints), TrialPoints);
  }

  /**
std::vector&lt; std::vector&lt; unsigned int &gt; &gt; itk::simple::FastMarchingUpwindGradientImageFilter::GetTrialPoints() const
*/
public  VectorUIntList getTrialPoints() {
    return new VectorUIntList(SimpleITKJNI.FastMarchingUpwindGradientImageFilter_getTrialPoints(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::FastMarchingUpwindGradientImageFilter::AddTrialPoint(std::vector&lt; unsigned int &gt; point)

Add TrialPoints point.

*/
public  void addTrialPoint(VectorUInt32 point) {
    SimpleITKJNI.FastMarchingUpwindGradientImageFilter_addTrialPoint(swigCPtr, this, VectorUInt32.getCPtr(point), point);
  }

  /**
Self&amp; itk::simple::FastMarchingUpwindGradientImageFilter::ClearTrialPoints()

Remove all TrialPoints points.

*/
public  void clearTrialPoints() {
    SimpleITKJNI.FastMarchingUpwindGradientImageFilter_clearTrialPoints(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastMarchingUpwindGradientImageFilter::SetNumberOfTargets(unsigned int NumberOfTargets)
*/
public  void setNumberOfTargets(long NumberOfTargets) {
    SimpleITKJNI.FastMarchingUpwindGradientImageFilter_setNumberOfTargets(swigCPtr, this, NumberOfTargets);
  }

  /**
unsigned int itk::simple::FastMarchingUpwindGradientImageFilter::GetNumberOfTargets() const

Get the number of targets.

*/
public  long getNumberOfTargets() {
    return SimpleITKJNI.FastMarchingUpwindGradientImageFilter_getNumberOfTargets(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastMarchingUpwindGradientImageFilter::SetTargetPoints(std::vector&lt; std::vector&lt; unsigned int &gt; &gt; TargetPoints)

Backwards compatibility for enum values Set the container of Target
Points. If a target point is reached, the propagation stops. Trial
points are represented as a VectorContainer of LevelSetNodes.

*/
public  void setTargetPoints(VectorUIntList TargetPoints) {
    SimpleITKJNI.FastMarchingUpwindGradientImageFilter_setTargetPoints(swigCPtr, this, VectorUIntList.getCPtr(TargetPoints), TargetPoints);
  }

  /**
std::vector&lt; std::vector&lt; unsigned int &gt; &gt; itk::simple::FastMarchingUpwindGradientImageFilter::GetTargetPoints() const

Get the container of Target Points.

*/
public  VectorUIntList getTargetPoints() {
    return new VectorUIntList(SimpleITKJNI.FastMarchingUpwindGradientImageFilter_getTargetPoints(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::FastMarchingUpwindGradientImageFilter::AddTargetPoint(std::vector&lt; unsigned int &gt; point)

Add TargetPoints point.

*/
public  void addTargetPoint(VectorUInt32 point) {
    SimpleITKJNI.FastMarchingUpwindGradientImageFilter_addTargetPoint(swigCPtr, this, VectorUInt32.getCPtr(point), point);
  }

  /**
Self&amp; itk::simple::FastMarchingUpwindGradientImageFilter::ClearTargetPoints()

Remove all TargetPoints points.

*/
public  void clearTargetPoints() {
    SimpleITKJNI.FastMarchingUpwindGradientImageFilter_clearTargetPoints(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastMarchingUpwindGradientImageFilter::SetTargetOffset(double TargetOffset)

Set how long (in terms of arrival times) after targets are reached the
front must stop. This is useful to ensure that the level set of target
arrival time is smooth.

*/
public  void setTargetOffset(double TargetOffset) {
    SimpleITKJNI.FastMarchingUpwindGradientImageFilter_setTargetOffset(swigCPtr, this, TargetOffset);
  }

  /**
double itk::simple::FastMarchingUpwindGradientImageFilter::GetTargetOffset() const

Get the TargetOffset ivar.

*/
public  double getTargetOffset() {
    return SimpleITKJNI.FastMarchingUpwindGradientImageFilter_getTargetOffset(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastMarchingUpwindGradientImageFilter::SetNormalizationFactor(double NormalizationFactor)

Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.

*/
public  void setNormalizationFactor(double NormalizationFactor) {
    SimpleITKJNI.FastMarchingUpwindGradientImageFilter_setNormalizationFactor(swigCPtr, this, NormalizationFactor);
  }

  /**
double itk::simple::FastMarchingUpwindGradientImageFilter::GetNormalizationFactor() const

Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.

*/
public  double getNormalizationFactor() {
    return SimpleITKJNI.FastMarchingUpwindGradientImageFilter_getNormalizationFactor(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastMarchingUpwindGradientImageFilter::SetInitialTrialValues(std::vector&lt; double &gt; InitialTrialValues)

Set the initial seed values for corresponding trial point.

*/
public  void setInitialTrialValues(VectorDouble InitialTrialValues) {
    SimpleITKJNI.FastMarchingUpwindGradientImageFilter_setInitialTrialValues(swigCPtr, this, VectorDouble.getCPtr(InitialTrialValues), InitialTrialValues);
  }

  /**
std::vector&lt;double&gt; itk::simple::FastMarchingUpwindGradientImageFilter::GetInitialTrialValues() const
*/
public  VectorDouble getInitialTrialValues() {
    return new VectorDouble(SimpleITKJNI.FastMarchingUpwindGradientImageFilter_getInitialTrialValues(swigCPtr, this), true);
  }

  /**
Image itk::simple::FastMarchingUpwindGradientImageFilter::GetGradientImage() const

Get the gradient image.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  Image getGradientImage() {
    return new Image(SimpleITKJNI.FastMarchingUpwindGradientImageFilter_getGradientImage(swigCPtr, this), true);
  }

  /**
double itk::simple::FastMarchingUpwindGradientImageFilter::GetTargetValue() const

Get the arrival time corresponding to the last reached target. If
TargetReachedMode is set to TargetConditionEnum::NoTargets ,
TargetValue contains the last (aka largest) Eikonal solution value
generated.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getTargetValue() {
    return SimpleITKJNI.FastMarchingUpwindGradientImageFilter_getTargetValue(swigCPtr, this);
  }

  /**
std::string itk::simple::FastMarchingUpwindGradientImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.FastMarchingUpwindGradientImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::FastMarchingUpwindGradientImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.FastMarchingUpwindGradientImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::FastMarchingUpwindGradientImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.FastMarchingUpwindGradientImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
