/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text.minimatch;

import com.intellij.util.text.minimatch.MinimatchOptions;
import com.intellij.util.text.minimatch.ParseItem;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/util/text/minimatch/MagicItem;", "Lcom/intellij/util/text/minimatch/ParseItem;", "source", "", "options", "Lcom/intellij/util/text/minimatch/MinimatchOptions;", "<init>", "(Ljava/lang/String;Lcom/intellij/util/text/minimatch/MinimatchOptions;)V", "pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "match", "", "file", "", "toString", "intellij.platform.util"})
public final class MagicItem
extends ParseItem {
    private final Pattern pattern;

    public MagicItem(@NotNull String source, @NotNull MinimatchOptions options) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(options, "options");
        super(source);
        this.pattern = Pattern.compile('^' + source + '$', options.getNocase() ? 2 : 0);
    }

    @Override
    public boolean match(@NotNull CharSequence file, @NotNull MinimatchOptions options) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(options, "options");
        return this.pattern.matcher(file).matches();
    }

    @NotNull
    public String toString() {
        return "RegExp(\"" + this.getSource() + "\")";
    }
}

