/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayCharSequence;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.LinkedList;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.lexer.EscapePreprocessor;
import org.intellij.plugins.relaxNG.compact.lexer.SimpleCharStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.rngom.parse.compact.CharStream;
import org.kohsuke.rngom.parse.compact.CompactSyntaxTokenManager;
import org.kohsuke.rngom.parse.compact.Token;
import org.kohsuke.rngom.parse.compact.TokenMgrError;

public final class CompactSyntaxLexerAdapter
extends LexerBase {
    private static final Logger LOG = Logger.getInstance((String)CompactSyntaxLexerAdapter.class.getName());
    private static final Field myStateField;
    private static final Token START;
    private CompactSyntaxTokenManager myLexer;
    private final LinkedList<Token> myTokenQueue = new LinkedList();
    private Token myCurrentToken;
    private int myCurrentOffset;
    private int myCurrentEnd;
    private IElementType myCurrentTokenType;
    private CharSequence myBuffer;
    private int myEndOffset;
    private Int2IntMap myLengthMap;

    public void advance() {
        try {
            this.myCurrentToken = this.nextToken();
            this.myCurrentOffset = this.myCurrentEnd;
            if (this.myCurrentToken != null) {
                this.myCurrentEnd = this.myCurrentOffset + this.myCurrentToken.image.length();
                for (int i = this.myCurrentOffset; i < this.myCurrentEnd; ++i) {
                    this.myCurrentEnd += this.myLengthMap.get(i);
                }
                if (this.myCurrentToken.kind == 0) {
                    assert (this.myCurrentOffset == this.myEndOffset) : "actual: " + this.myCurrentOffset + ", expected: " + this.myEndOffset;
                    this.myCurrentToken = null;
                }
            }
        }
        catch (TokenMgrError e) {
            LOG.error((Throwable)e);
            this.myCurrentToken = null;
        }
        if (this.myCurrentToken == null) {
            this.myCurrentTokenType = null;
        } else {
            this.myCurrentTokenType = RncTokenTypes.get(this.myCurrentToken.kind);
            if (RncTokenTypes.WHITESPACE.contains(this.myCurrentTokenType)) {
                this.myCurrentTokenType = TokenType.WHITE_SPACE;
            }
        }
    }

    private Token nextToken() {
        if (!this.myTokenQueue.isEmpty()) {
            return this.myTokenQueue.removeFirst();
        }
        Token t = this.myLexer.getNextToken();
        if (t.specialToken != null) {
            this.myTokenQueue.addFirst(t);
            Token s = t.specialToken;
            while (s != null) {
                this.myTokenQueue.addFirst(s);
                s = s.specialToken;
            }
            return this.myTokenQueue.removeFirst();
        }
        return t;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            CompactSyntaxLexerAdapter.$$$reportNull$$$0(0);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }

    public int getState() {
        try {
            return (Integer)myStateField.get(this.myLexer);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int getTokenEnd() {
        return this.myCurrentEnd;
    }

    public int getTokenStart() {
        return this.myCurrentToken == null ? 0 : this.myCurrentOffset;
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.myCurrentToken == null) {
            return null;
        }
        return this.myCurrentTokenType;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            CompactSyntaxLexerAdapter.$$$reportNull$$$0(1);
        }
        this.myBuffer = buffer;
        CharSequenceReader reader = new CharSequenceReader(buffer, startOffset, endOffset);
        this.init(startOffset, endOffset, reader, initialState);
    }

    private void init(int startOffset, int endOffset, Reader reader, int initialState) {
        this.myEndOffset = endOffset;
        this.myLengthMap = new Int2IntOpenHashMap();
        this.myLexer = CompactSyntaxLexerAdapter.createTokenManager(initialState, new EscapePreprocessor(reader, startOffset, this.myLengthMap));
        this.myCurrentToken = START;
        this.myCurrentOffset = startOffset;
        this.myCurrentEnd = startOffset;
        this.myTokenQueue.clear();
        this.advance();
    }

    private static CompactSyntaxTokenManager createTokenManager(int initialState, EscapePreprocessor preprocessor) {
        try {
            return new CompactSyntaxTokenManager(new SimpleCharStream(preprocessor, 1, 1), initialState);
        }
        catch (NoSuchMethodError e) {
            Class<CompactSyntaxTokenManager> managerClass = CompactSyntaxTokenManager.class;
            LOG.error("Unsupported version of RNGOM in classpath. Please check your IDEA and JDK installation.", (Throwable)e, new String[]{"Actual parameter types: " + Arrays.toString(managerClass.getConstructors()[0].getParameterTypes()), "Location of " + managerClass.getName() + ": " + CompactSyntaxLexerAdapter.getSourceLocation(managerClass), "Location of " + CharStream.class.getName() + ": " + CompactSyntaxLexerAdapter.getSourceLocation(CharStream.class)});
            throw e;
        }
    }

    private static String getSourceLocation(Class<?> clazz) {
        URL location;
        CodeSource source = clazz.getProtectionDomain().getCodeSource();
        if (source != null && (location = source.getLocation()) != null) {
            return location.toExternalForm();
        }
        String name = clazz.getName().replace('.', '/') + ".class";
        ClassLoader loader = clazz.getClassLoader();
        URL resource = loader != null ? loader.getResource(name) : ClassLoader.getSystemResource(name);
        return resource != null ? resource.toExternalForm() : "<unknown>";
    }

    public static void main(String[] args) throws IOException {
        CompactSyntaxLexerAdapter lexer = new CompactSyntaxLexerAdapter();
        lexer.start((CharSequence)new CharArrayCharSequence(FileUtil.adaptiveLoadText((Reader)new FileReader(args[0]))));
        while (lexer.getTokenType() != null) {
            System.out.println("token = " + String.valueOf(lexer.getTokenType()));
            int start = lexer.getTokenStart();
            System.out.println("start = " + start);
            int end = lexer.getTokenEnd();
            System.out.println("end = " + end);
            CharSequence t = lexer.getBufferSequence().subSequence(start, end);
            System.out.println("t = " + String.valueOf(t));
            lexer.advance();
        }
    }

    static {
        try {
            myStateField = CompactSyntaxTokenManager.class.getDeclaredField("curLexState");
            myStateField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        START = new Token();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/compact/lexer/CompactSyntaxLexerAdapter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/compact/lexer/CompactSyntaxLexerAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    static class CharSequenceReader
    extends Reader {
        private final CharSequence myText;
        private final int myEndOffset;
        private int myCurPos;

        CharSequenceReader(CharSequence text, int startOffset, int endOffset) {
            this.myText = text;
            this.myEndOffset = endOffset;
            this.myCurPos = startOffset;
        }

        @Override
        public void close() {
        }

        @Override
        public int read(char[] cbuf, int off, int len) {
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.myText instanceof CharArrayCharSequence) {
                int readChars = ((CharArrayCharSequence)this.myText).readCharsTo(this.myCurPos, cbuf, off, len);
                if (readChars < 0) {
                    return -1;
                }
                this.myCurPos += readChars;
                return readChars;
            }
            int charsToCopy = Math.min(len, this.myEndOffset - this.myCurPos);
            if (charsToCopy <= 0) {
                return -1;
            }
            for (int n = 0; n < charsToCopy; ++n) {
                cbuf[n + off] = this.myText.charAt(n + this.myCurPos);
            }
            this.myCurPos += charsToCopy;
            return charsToCopy;
        }

        @Override
        public int read() {
            if (this.myCurPos >= this.myEndOffset) {
                return -1;
            }
            return this.myText.charAt(this.myCurPos++);
        }
    }
}

