/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.utils;

import com.intellij.maven.server.telemetry.MavenServerOpenTelemetry;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.util.ExceptionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.LongRunningTask;
import org.jetbrains.idea.maven.server.Maven3AetherModelConverter;
import org.jetbrains.idea.maven.server.Maven3EffectivePomDumper;
import org.jetbrains.idea.maven.server.Maven3ImporterSpy;
import org.jetbrains.idea.maven.server.Maven3ModelConverter;
import org.jetbrains.idea.maven.server.Maven3TransferListenerAdapter;
import org.jetbrains.idea.maven.server.Maven3WorkspaceMapReader;
import org.jetbrains.idea.maven.server.Maven3XProfileUtil;
import org.jetbrains.idea.maven.server.Maven3XServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicator;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicatorImpl;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerStatsCollector;
import org.jetbrains.idea.maven.server.PomHashMap;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ModelInterpolator2;
import org.jetbrains.idea.maven.server.utils.Maven3ResolverUtil;

public class Maven3XProjectResolver {
    @NotNull
    protected final Maven3XServerEmbedder myEmbedder;
    @NotNull
    private final MavenServerOpenTelemetry myTelemetry;
    private final boolean myUpdateSnapshots;
    @NotNull
    private final Maven3ImporterSpy myImporterSpy;
    private final LongRunningTask myLongRunningTask;
    @NotNull
    @NotNull List<@NotNull File> myFilesToResolve;
    private final PomHashMap myPomHashMap;
    private final List<String> myActiveProfiles;
    private final List<String> myInactiveProfiles;
    @Nullable
    protected final MavenWorkspaceMap myWorkspaceMap;
    @NotNull
    private final Properties userProperties;
    private final boolean myResolveInParallel;

    public Maven3XProjectResolver(@NotNull Maven3XServerEmbedder embedder, @NotNull MavenServerOpenTelemetry telemetry, boolean updateSnapshots, @NotNull Maven3ImporterSpy importerSpy, @NotNull LongRunningTask longRunningTask, @NotNull @NotNull List<@NotNull File> filesToResolve, @NotNull PomHashMap pomHashMap, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, @Nullable MavenWorkspaceMap workspaceMap, @NotNull Properties userProperties, boolean resolveInParallel) {
        if (embedder == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(0);
        }
        if (telemetry == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(1);
        }
        if (importerSpy == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(2);
        }
        if (longRunningTask == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(3);
        }
        if (filesToResolve == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(4);
        }
        if (pomHashMap == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(5);
        }
        if (activeProfiles == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(6);
        }
        if (inactiveProfiles == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(7);
        }
        if (userProperties == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(8);
        }
        this.myEmbedder = embedder;
        this.myTelemetry = telemetry;
        this.myUpdateSnapshots = updateSnapshots;
        this.myImporterSpy = importerSpy;
        this.myLongRunningTask = longRunningTask;
        this.myFilesToResolve = filesToResolve;
        this.myPomHashMap = pomHashMap;
        this.myActiveProfiles = activeProfiles;
        this.myInactiveProfiles = inactiveProfiles;
        this.myWorkspaceMap = workspaceMap;
        this.userProperties = userProperties;
        this.myResolveInParallel = resolveInParallel;
    }

    @NotNull
    public ArrayList<MavenServerExecutionResult> resolveProjects() {
        ArrayList arrayList;
        try {
            arrayList = (ArrayList)this.myTelemetry.callWithSpan("doResolveProject", () -> this.doResolveProject());
        }
        catch (Exception e) {
            throw this.myEmbedder.wrapToSerializableRuntimeException(e);
        }
        if (arrayList == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private ArrayList<MavenServerExecutionResult> doResolveProject() {
        List<File> files = this.myFilesToResolve;
        File file = !files.isEmpty() ? files.iterator().next() : null;
        files.forEach(f -> MavenServerStatsCollector.fileRead((File)f));
        MavenExecutionRequest request = this.myEmbedder.createRequest(file, this.myActiveProfiles, this.myInactiveProfiles, this.userProperties);
        request.setUpdateSnapshots(this.myUpdateSnapshots);
        ArrayList<MavenServerExecutionResult> executionResults = new ArrayList<MavenServerExecutionResult>();
        this.myEmbedder.executeWithMavenSession(request, () -> executionResults.addAll(this.getExecutionResults(files, request)));
        ArrayList<MavenServerExecutionResult> arrayList = executionResults;
        if (arrayList == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private ArrayList<MavenServerExecutionResult> getExecutionResults(Collection<File> files, MavenExecutionRequest request) {
        ArrayList<MavenServerExecutionResult> executionResults = new ArrayList<MavenServerExecutionResult>();
        try {
            MavenSession mavenSession = this.myEmbedder.getComponent(LegacySupport.class).getSession();
            RepositorySystemSession repositorySession = this.myEmbedder.getComponent(LegacySupport.class).getRepositorySession();
            if (repositorySession instanceof DefaultRepositorySystemSession) {
                DefaultRepositorySystemSession session = (DefaultRepositorySystemSession)repositorySession;
                MavenServerConsoleIndicatorImpl indicator = this.myLongRunningTask.getIndicator();
                this.myImporterSpy.setIndicator((MavenServerConsoleIndicator)indicator);
                session.setTransferListener((TransferListener)new Maven3TransferListenerAdapter(indicator));
                this.setupWorkspaceReader(session);
                session.setConfigProperty("aether.conflictResolver.verbose", (Object)true);
                session.setConfigProperty("aether.dependencyManager.verbose", (Object)true);
            }
            List buildingResults = (List)this.myTelemetry.callWithSpan("getProjectBuildingResults " + files.size(), () -> this.getProjectBuildingResults(request, files));
            Maven3XProjectResolver.fillSessionCache(mavenSession, repositorySession, buildingResults);
            boolean addUnresolved = System.getProperty("idea.maven.no.use.dependency.graph") == null;
            boolean runInParallel = this.myResolveInParallel;
            Map<File, String> fileToNewDependencyHash = this.collectHashes(runInParallel, buildingResults);
            ArrayList<ProjectBuildingResultInfo> buildingResultInfos = new ArrayList<ProjectBuildingResultInfo>();
            for (ProjectBuildingResult buildingResult : buildingResults) {
                MavenProject project = buildingResult.getProject();
                String projectId = buildingResult.getProjectId();
                File pomFile = buildingResult.getPomFile();
                List modelProblems = buildingResult.getProblems();
                if (project == null || pomFile == null) {
                    executionResults.add(this.createExecutionResult(pomFile, modelProblems));
                    continue;
                }
                boolean hasErrors = false;
                for (ModelProblem p : modelProblems) {
                    if (p.getSeverity() != ModelProblem.Severity.ERROR && p.getSeverity() != ModelProblem.Severity.FATAL) continue;
                    hasErrors = true;
                    break;
                }
                if (hasErrors) {
                    executionResults.add(this.createExecutionResult(pomFile, Collections.emptyList(), modelProblems, project, null, null, false));
                    continue;
                }
                String newDependencyHash = fileToNewDependencyHash.get(pomFile);
                if (!this.transitiveDependenciesChanged(pomFile, newDependencyHash, fileToNewDependencyHash)) {
                    executionResults.add(this.createExecutionResult(project, newDependencyHash));
                    continue;
                }
                ArrayList<Exception> exceptions = new ArrayList<Exception>();
                this.loadExtensions(project, exceptions);
                project.setDependencyArtifacts(project.createArtifacts(this.myEmbedder.getComponent(ArtifactFactory.class), null, null));
                buildingResultInfos.add(new ProjectBuildingResultInfo(projectId, project, modelProblems, exceptions, newDependencyHash));
            }
            this.myLongRunningTask.updateTotalRequests(buildingResultInfos.size());
            Collection execResults = (Collection)this.myTelemetry.callWithSpan("resolveBuildingResults", () -> this.myTelemetry.execute(runInParallel, (Collection)buildingResultInfos, br -> {
                if (this.myLongRunningTask.isCanceled()) {
                    return MavenServerExecutionResult.EMPTY;
                }
                MavenServerExecutionResult result = (MavenServerExecutionResult)this.myTelemetry.callWithSpan("resolveBuildingResult " + br.projectId, () -> this.resolveBuildingResult(repositorySession, addUnresolved, br.mavenProject, br.modelProblems, br.exceptions, br.dependencyHash));
                this.myLongRunningTask.incrementFinishedRequests();
                return result;
            }));
            executionResults.addAll(execResults);
        }
        catch (Exception e) {
            executionResults.add(this.createExecutionResult(e));
        }
        ArrayList<MavenServerExecutionResult> arrayList = executionResults;
        if (arrayList == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private boolean transitiveDependenciesChanged(@NotNull File pomFile, String newDependencyHash, Map<File, String> fileToNewDependencyHash) {
        if (pomFile == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(12);
        }
        if (this.dependenciesChanged(pomFile, newDependencyHash)) {
            return true;
        }
        for (File dependencyPomFile : this.myPomHashMap.getFileDependencies(pomFile)) {
            if (!this.dependenciesChanged(dependencyPomFile, fileToNewDependencyHash.get(dependencyPomFile))) continue;
            return true;
        }
        return false;
    }

    private boolean dependenciesChanged(@NotNull File pomFile, String newDependencyHash) {
        String previousDependencyHash;
        if (pomFile == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(13);
        }
        return (previousDependencyHash = this.myPomHashMap.getDependencyHash(pomFile)) == null || !previousDependencyHash.equals(newDependencyHash);
    }

    @NotNull
    private Map<File, String> collectHashes(boolean runInParallel, List<ProjectBuildingResult> buildingResults) {
        ConcurrentHashMap<File, String> fileToNewDependencyHash = new ConcurrentHashMap<File, String>();
        this.myTelemetry.callWithSpan("dependencyHashes", () -> this.myTelemetry.execute(runInParallel, (Collection)buildingResults, br -> {
            File pomFile;
            String newDependencyHash = Maven3EffectivePomDumper.dependencyHash((MavenProject)br.getProject());
            if (null != newDependencyHash && (pomFile = br.getPomFile()) != null) {
                fileToNewDependencyHash.put(pomFile, newDependencyHash);
            }
            return br;
        }));
        ConcurrentHashMap<File, String> concurrentHashMap = fileToNewDependencyHash;
        if (concurrentHashMap == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(14);
        }
        return concurrentHashMap;
    }

    protected void setupWorkspaceReader(DefaultRepositorySystemSession session) {
        String mavenVersion = System.getProperty("idea.maven.embedder.version");
        if (VersionComparatorUtil.compare((String)mavenVersion, (String)"3.3.1") < 0) {
            return;
        }
        if (this.myWorkspaceMap != null) {
            session.setWorkspaceReader((WorkspaceReader)new Maven3WorkspaceMapReader(this.myWorkspaceMap, this.myEmbedder.getSystemProperties()));
        }
    }

    @NotNull
    private MavenServerExecutionResult resolveBuildingResult(RepositorySystemSession repositorySession, boolean addUnresolved, MavenProject project, @NotNull List<ModelProblem> modelProblems, List<Exception> exceptions, String dependencyHash) {
        if (modelProblems == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(15);
        }
        try {
            DependencyResolutionResult dependencyResolutionResult = this.resolveDependencies(project, repositorySession);
            Set<Artifact> artifacts = this.resolveArtifacts(dependencyResolutionResult, addUnresolved);
            project.setArtifacts(artifacts);
            return this.createExecutionResult(exceptions, modelProblems, project, dependencyResolutionResult, dependencyHash);
        }
        catch (Exception e) {
            return this.createExecutionResult(project, e);
        }
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(@NotNull MavenProject mavenProject, String dependencyHash) {
        if (mavenProject == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(16);
        }
        return this.createExecutionResult(mavenProject.getFile(), Collections.emptyList(), Collections.emptyList(), mavenProject, null, dependencyHash, true);
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(Exception exception) {
        return this.createExecutionResult(null, exception);
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(MavenProject mavenProject, Exception exception) {
        return this.createExecutionResult(Collections.singletonList(exception), Collections.emptyList(), mavenProject, null, null);
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(List<Exception> exceptions, List<ModelProblem> modelProblems, MavenProject mavenProject, DependencyResolutionResult dependencyResolutionResult, String dependencyHash) {
        return this.createExecutionResult(null, exceptions, modelProblems, mavenProject, dependencyResolutionResult, dependencyHash, false);
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(@Nullable File file, List<ModelProblem> modelProblems) {
        return this.createExecutionResult(file, Collections.emptyList(), modelProblems, null, null, null, false);
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(@Nullable File file, @NotNull List<Exception> exceptions, @NotNull List<ModelProblem> modelProblems, @Nullable MavenProject mavenProject, DependencyResolutionResult dependencyResolutionResult, String dependencyHash, boolean dependencyResolutionSkipped) {
        if (exceptions == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(17);
        }
        if (modelProblems == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(18);
        }
        if (null != dependencyResolutionResult && null != dependencyResolutionResult.getCollectionErrors()) {
            exceptions.addAll(dependencyResolutionResult.getCollectionErrors());
        }
        if (null == file && null != mavenProject) {
            file = mavenProject.getFile();
        }
        Collection<MavenProjectProblem> problems = this.myEmbedder.collectProblems(file, exceptions, modelProblems);
        if (mavenProject == null) {
            return new MavenServerExecutionResult(file, null, problems, Collections.emptySet());
        }
        MavenModel model = new MavenModel();
        try {
            DependencyNode dependencyGraph = dependencyResolutionResult != null ? dependencyResolutionResult.getDependencyGraph() : null;
            List dependencyNodes = dependencyGraph != null ? dependencyGraph.getChildren() : Collections.emptyList();
            model = Maven3AetherModelConverter.convertModelWithAetherDependencyTree(mavenProject.getModel(), mavenProject.getCompileSourceRoots(), mavenProject.getTestCompileSourceRoots(), mavenProject.getArtifacts(), dependencyNodes, mavenProject.getPluginArtifacts(), mavenProject.getExtensionArtifacts(), this.myEmbedder.getLocalRepositoryFile());
        }
        catch (Exception e) {
            problems.addAll(this.myEmbedder.collectProblems(mavenProject.getFile(), Collections.singleton(e), modelProblems));
        }
        Collection<String> activatedProfiles = Maven3XProfileUtil.collectActivatedProfiles(mavenProject);
        Map mavenModelMap = Maven3ModelConverter.convertToMap((Object)mavenProject.getModel());
        MavenServerExecutionResult.ProjectData data = new MavenServerExecutionResult.ProjectData(model, Maven3XProjectResolver.getManagedDependencies(mavenProject), dependencyHash, dependencyResolutionSkipped, mavenModelMap, activatedProfiles);
        HashSet<MavenProjectProblem> unresolvedProblems = new HashSet<MavenProjectProblem>();
        this.collectUnresolvedArtifactProblems(file, dependencyResolutionResult, unresolvedProblems);
        return new MavenServerExecutionResult(file, data, problems, Collections.emptySet(), unresolvedProblems);
    }

    @NotNull
    private static List<MavenArtifactInfo> getManagedDependencies(@Nullable MavenProject project) {
        if (project == null || project.getDependencyManagement() == null || project.getDependencyManagement().getDependencies() == null) {
            List<MavenArtifactInfo> list = Collections.emptyList();
            if (list == null) {
                Maven3XProjectResolver.$$$reportNull$$$0(19);
            }
            return list;
        }
        List<MavenArtifactInfo> list = project.getDependencyManagement().getDependencies().stream().map(dep -> new MavenArtifactInfo(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getType(), dep.getClassifier())).collect(Collectors.toList());
        if (list == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static void fillSessionCache(MavenSession mavenSession, RepositorySystemSession session, List<ProjectBuildingResult> buildingResults) {
        String mavenVersion = System.getProperty("idea.maven.embedder.version");
        if (VersionComparatorUtil.compare((String)mavenVersion, (String)"3.3.1") < 0) {
            return;
        }
        if (session instanceof DefaultRepositorySystemSession) {
            int initialCapacity = (int)((double)buildingResults.size() * 1.5);
            HashMap<MavenId, Model> cacheMavenModelMap = new HashMap<MavenId, Model>(initialCapacity);
            HashMap<String, MavenProject> mavenProjectMap = new HashMap<String, MavenProject>(initialCapacity);
            for (ProjectBuildingResult result : buildingResults) {
                if (result.getProblems() != null && !result.getProblems().isEmpty()) continue;
                Model model = result.getProject().getModel();
                String key = ArtifactUtils.key((String)model.getGroupId(), (String)model.getArtifactId(), (String)model.getVersion());
                mavenProjectMap.put(key, result.getProject());
                cacheMavenModelMap.put(new MavenId(model.getGroupId(), model.getArtifactId(), model.getVersion()), model);
            }
            mavenSession.setProjectMap(mavenProjectMap);
            DefaultRepositorySystemSession defaultSession = (DefaultRepositorySystemSession)session;
            WorkspaceReader reader = defaultSession.getWorkspaceReader();
            if (reader instanceof Maven3WorkspaceMapReader) {
                Maven3WorkspaceMapReader mapReader = (Maven3WorkspaceMapReader)reader;
                mapReader.fillSessionCache(cacheMavenModelMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected List<ProjectBuildingResult> getProjectBuildingResults(@NotNull MavenExecutionRequest request, @NotNull Collection<File> files) {
        if (request == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(21);
        }
        if (files == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(22);
        }
        ProjectBuilder builder = this.myEmbedder.getComponent(ProjectBuilder.class);
        ModelInterpolator modelInterpolator = this.myEmbedder.getComponent(ModelInterpolator.class);
        String savedLocalRepository = null;
        if (modelInterpolator instanceof CustomMaven3ModelInterpolator2) {
            CustomMaven3ModelInterpolator2 customMaven3ModelInterpolator2 = (CustomMaven3ModelInterpolator2)modelInterpolator;
            savedLocalRepository = customMaven3ModelInterpolator2.getLocalRepository();
            customMaven3ModelInterpolator2.setLocalRepository(request.getLocalRepositoryPath().getAbsolutePath());
        }
        ArrayList<ProjectBuildingResult> buildingResults = new ArrayList<ProjectBuildingResult>();
        ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
        projectBuildingRequest.setValidationLevel(0);
        projectBuildingRequest.setResolveDependencies(false);
        try {
            try {
                this.buildMultiplyPoms(builder, buildingResults, projectBuildingRequest, files);
            }
            catch (ProjectBuildingException e) {
                for (ProjectBuildingResult result : e.getResults()) {
                    if (result.getProject() != null) {
                        buildingResults.add(result);
                        continue;
                    }
                    this.buildSinglePom(builder, buildingResults, projectBuildingRequest, result.getPomFile());
                }
            }
        }
        finally {
            if (modelInterpolator instanceof CustomMaven3ModelInterpolator2 && savedLocalRepository != null) {
                ((CustomMaven3ModelInterpolator2)modelInterpolator).setLocalRepository(savedLocalRepository);
            }
        }
        ArrayList<ProjectBuildingResult> arrayList = buildingResults;
        if (arrayList == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    protected void buildMultiplyPoms(@NotNull ProjectBuilder builder, List<ProjectBuildingResult> buildingResults, ProjectBuildingRequest projectBuildingRequest, @NotNull Collection<File> files) throws ProjectBuildingException {
        if (builder == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(24);
        }
        if (files == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(25);
        }
        buildingResults.addAll(builder.build(new ArrayList<File>(files), true, projectBuildingRequest));
    }

    protected void buildSinglePom(ProjectBuilder builder, List<ProjectBuildingResult> buildingResults, ProjectBuildingRequest projectBuildingRequest, File pomFile) {
        try {
            ProjectBuildingResult build = builder.build(pomFile, projectBuildingRequest);
            buildingResults.add(build);
        }
        catch (ProjectBuildingException e) {
            Maven3ResolverUtil.handleProjectBuildingException(buildingResults, (ProjectBuildingException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtensions(MavenProject project, List<Exception> exceptions) {
        LegacySupport legacySupport;
        MavenSession session;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Collection<AbstractMavenLifecycleParticipant> lifecycleParticipants = this.getLifecycleParticipants(Collections.singletonList(project));
        if (!lifecycleParticipants.isEmpty() && null != (session = (legacySupport = this.myEmbedder.getComponent(LegacySupport.class)).getSession())) {
            session.setCurrentProject(project);
            try {
                session.setAllProjects(Collections.singletonList(project));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            session.setProjects(Collections.singletonList(project));
            for (AbstractMavenLifecycleParticipant listener : lifecycleParticipants) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                try {
                    listener.afterProjectsRead(session);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
        }
    }

    private DependencyResolutionResult resolveDependencies(MavenProject project, RepositorySystemSession session) {
        DependencyResolutionResult resolutionResult;
        try {
            ProjectDependenciesResolver dependencyResolver = this.myEmbedder.getComponent(ProjectDependenciesResolver.class);
            DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(project, session);
            resolutionResult = dependencyResolver.resolve((DependencyResolutionRequest)resolution);
        }
        catch (DependencyResolutionException e) {
            resolutionResult = e.getResult();
        }
        LinkedHashSet artifacts = new LinkedHashSet();
        if (resolutionResult.getDependencyGraph() != null) {
            RepositoryUtils.toArtifacts(artifacts, (Collection)resolutionResult.getDependencyGraph().getChildren(), Collections.singletonList(project.getArtifact().getId()), null);
            LocalRepositoryManager lrm = session.getLocalRepositoryManager();
            for (Artifact artifact : artifacts) {
                if (artifact.isResolved()) continue;
                String path = lrm.getPathForLocalArtifact(RepositoryUtils.toArtifact((Artifact)artifact));
                artifact.setFile(new File(lrm.getRepository().getBasedir(), path));
            }
        }
        project.setResolvedArtifacts(artifacts);
        project.setArtifacts(artifacts);
        return resolutionResult;
    }

    @NotNull
    private Set<Artifact> resolveArtifacts(DependencyResolutionResult dependencyResolutionResult, boolean addUnresolvedNodes) {
        IdentityHashMap<Dependency, Artifact> winnerDependencyMap = new IdentityHashMap<Dependency, Artifact>();
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        Set addedDependencies = Collections.newSetFromMap(new IdentityHashMap());
        Maven3XProjectResolver.resolveConflicts(dependencyResolutionResult, winnerDependencyMap);
        if (dependencyResolutionResult.getDependencyGraph() != null) {
            dependencyResolutionResult.getDependencyGraph().getChildren();
        }
        for (Dependency dependency : dependencyResolutionResult.getDependencies()) {
            Artifact artifact = dependency == null ? null : (Artifact)winnerDependencyMap.get(dependency);
            if (artifact == null) continue;
            addedDependencies.add(dependency);
            artifacts.add(artifact);
            this.resolveAsModule(artifact);
        }
        if (addUnresolvedNodes) {
            ArrayDeque queue = new ArrayDeque(dependencyResolutionResult.getDependencyGraph().getChildren());
            while (!queue.isEmpty()) {
                Artifact artifact;
                DependencyNode node = (DependencyNode)queue.poll();
                queue.addAll(node.getChildren());
                Dependency dependency = node.getDependency();
                if (dependency == null || !addedDependencies.add(dependency) || (artifact = (Artifact)winnerDependencyMap.get(dependency)) == null) continue;
                addedDependencies.add(dependency);
                artifacts.add(artifact);
                this.resolveAsModule(artifact);
            }
        }
        LinkedHashSet<Artifact> linkedHashSet = artifacts;
        if (linkedHashSet == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(26);
        }
        return linkedHashSet;
    }

    private static void resolveConflicts(DependencyResolutionResult dependencyResolutionResult, final Map<Dependency, Artifact> winnerDependencyMap) {
        dependencyResolutionResult.getDependencyGraph().accept((DependencyVisitor)new TreeDependencyVisitor(new DependencyVisitor(){

            public boolean visitEnter(DependencyNode node) {
                Object winner = node.getData().get("conflict.winner");
                Dependency dependency = node.getDependency();
                if (dependency != null && winner == null) {
                    Artifact winnerArtifact = Maven3AetherModelConverter.toArtifact(dependency);
                    winnerDependencyMap.put(dependency, winnerArtifact);
                }
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                return true;
            }
        }));
    }

    private boolean resolveAsModule(Artifact a) {
        MavenWorkspaceMap map = this.myWorkspaceMap;
        if (map == null) {
            return false;
        }
        MavenWorkspaceMap.Data resolved = map.findFileAndOriginalId(Maven3ModelConverter.createMavenId((Artifact)a));
        if (resolved == null) {
            return false;
        }
        a.setResolved(true);
        a.setFile(resolved.getFile(a.getType()));
        a.selectVersion(resolved.originalId.getVersion());
        return true;
    }

    private void collectUnresolvedArtifactProblems(@Nullable File file, @Nullable DependencyResolutionResult result, Collection<MavenProjectProblem> problems) {
        if (result == null) {
            return;
        }
        String path = file == null ? "" : file.getPath();
        for (Dependency unresolvedDependency : result.getUnresolvedDependencies()) {
            Iterator iterator = result.getResolutionErrors(unresolvedDependency).iterator();
            if (!iterator.hasNext()) continue;
            Exception exception = (Exception)iterator.next();
            String message = Maven3XProjectResolver.getRootMessage(exception);
            Artifact artifact = RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)unresolvedDependency.getArtifact());
            MavenArtifact mavenArtifact = Maven3ModelConverter.convertArtifact((Artifact)artifact, (File)this.myEmbedder.getLocalRepositoryFile());
            problems.add(MavenProjectProblem.createUnresolvedArtifactProblem((String)path, (String)message, (boolean)false, (MavenArtifact)mavenArtifact));
        }
    }

    @NotNull
    private static String getRootMessage(Throwable each) {
        String baseMessage = each.getMessage() != null ? each.getMessage() : "";
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)each);
        String rootMessage = rootCause != null ? rootCause.getMessage() : "";
        String string = StringUtils.isNotEmpty((String)rootMessage) ? rootMessage : baseMessage;
        if (string == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(27);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AbstractMavenLifecycleParticipant> getLifecycleParticipants(Collection<MavenProject> projects) {
        LinkedHashSet<AbstractMavenLifecycleParticipant> lifecycleListeners = new LinkedHashSet<AbstractMavenLifecycleParticipant>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            lifecycleListeners.addAll(this.myEmbedder.getComponents(AbstractMavenLifecycleParticipant.class));
            HashSet<ClassRealm> scannedRealms = new HashSet<ClassRealm>();
            for (MavenProject project : projects) {
                ClassRealm projectRealm = project.getClassRealm();
                if (projectRealm == null || !scannedRealms.add(projectRealm)) continue;
                Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                lifecycleListeners.addAll(this.myEmbedder.getComponents(AbstractMavenLifecycleParticipant.class));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return lifecycleListeners;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "telemetry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importerSpy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "longRunningTask";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToResolve";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pomHashMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inactiveProfiles";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userProperties";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/utils/Maven3XProjectResolver";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pomFile";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelProblems";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/utils/Maven3XProjectResolver";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProjects";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionResults";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectHashes";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getManagedDependencies";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectBuildingResults";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifacts";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "transitiveDependenciesChanged";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "dependenciesChanged";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveBuildingResult";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionResult";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getProjectBuildingResults";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "buildMultiplyPoms";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProjectBuildingResultInfo {
        @NotNull
        String projectId;
        @NotNull
        MavenProject mavenProject;
        @NotNull
        List<ModelProblem> modelProblems;
        @NotNull
        List<Exception> exceptions;
        String dependencyHash;

        private ProjectBuildingResultInfo(@NotNull String projectId, @NotNull MavenProject mavenProject, @NotNull List<ModelProblem> modelProblems, @NotNull List<Exception> exceptions, String dependencyHash) {
            if (projectId == null) {
                ProjectBuildingResultInfo.$$$reportNull$$$0(0);
            }
            if (mavenProject == null) {
                ProjectBuildingResultInfo.$$$reportNull$$$0(1);
            }
            if (modelProblems == null) {
                ProjectBuildingResultInfo.$$$reportNull$$$0(2);
            }
            if (exceptions == null) {
                ProjectBuildingResultInfo.$$$reportNull$$$0(3);
            }
            this.projectId = projectId;
            this.mavenProject = mavenProject;
            this.modelProblems = modelProblems;
            this.exceptions = exceptions;
            this.dependencyHash = dependencyHash;
        }

        public String toString() {
            return "ProjectBuildingResultData{projectId=" + this.projectId + ", dependencyHash=" + this.dependencyHash + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "projectId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mavenProject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modelProblems";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exceptions";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/server/utils/Maven3XProjectResolver$ProjectBuildingResultInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

